/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.container;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.container.RawDataContainer;
import com.djrapitops.plan.delivery.domain.container.SupplierDataContainer;
import com.djrapitops.plan.delivery.domain.keys.Key;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class DynamicDataContainer
implements DataContainer {
    private final SupplierDataContainer supplierDataContainer = new SupplierDataContainer();
    private final RawDataContainer rawDataContainer = new RawDataContainer();

    @Override
    public <T> void putRawData(Key<T> key, T obj) {
        this.rawDataContainer.putRawData(key, obj);
    }

    @Override
    public <T> void putSupplier(Key<T> key, Supplier<T> supplier) {
        this.supplierDataContainer.putSupplier(key, supplier);
    }

    @Override
    public <T> void putCachingSupplier(Key<T> key, Supplier<T> supplier) {
        this.supplierDataContainer.putCachingSupplier(key, supplier);
    }

    @Override
    public <T> boolean supports(Key<T> key) {
        return this.rawDataContainer.supports(key) || this.supplierDataContainer.supports(key);
    }

    @Override
    public <T> Optional<T> getValue(Key<T> key) {
        Optional<T> raw = this.rawDataContainer.getValue(key);
        if (raw.isPresent()) {
            return raw;
        }
        return this.supplierDataContainer.getValue(key);
    }

    @Override
    public <T> T getUnsafe(Key<T> key) {
        if (this.rawDataContainer.supports(key)) {
            return this.rawDataContainer.getUnsafe(key);
        }
        return this.supplierDataContainer.getUnsafe(key);
    }

    @Override
    public void putAll(DataContainer dataContainer) {
        if (dataContainer instanceof SupplierDataContainer) {
            this.supplierDataContainer.putAll(dataContainer);
        } else if (dataContainer instanceof RawDataContainer) {
            this.rawDataContainer.putAll(dataContainer);
        } else {
            this.rawDataContainer.putAll(dataContainer.getMap());
        }
    }

    @Override
    public void clear() {
        this.rawDataContainer.clear();
        this.supplierDataContainer.clear();
    }

    @Override
    public Map<Key, Object> getMap() {
        Map<Key, Object> map = this.supplierDataContainer.getMap();
        map.putAll(this.rawDataContainer.getMap());
        return map;
    }
}

