/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.container;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.container.DynamicDataContainer;
import com.djrapitops.plan.delivery.domain.keys.Key;
import com.djrapitops.plan.delivery.domain.keys.PerServerKeys;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.UserInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class PerServerContainer
extends HashMap<UUID, DataContainer> {
    public <T> void putToContainerOfServer(UUID serverUUID, Key<T> key, T value) {
        DataContainer container = this.getOrDefault(serverUUID, new DynamicDataContainer());
        container.putRawData(key, value);
        this.put(serverUUID, container);
    }

    public void putUserInfo(UserInfo userInfo) {
        UUID serverUUID = userInfo.getServerUUID();
        this.putToContainerOfServer(serverUUID, PerServerKeys.REGISTERED, userInfo.getRegistered());
        this.putToContainerOfServer(serverUUID, PerServerKeys.BANNED, userInfo.isBanned());
        this.putToContainerOfServer(serverUUID, PerServerKeys.OPERATOR, userInfo.isOperator());
    }

    public void putUserInfo(Collection<UserInfo> userInformation) {
        for (UserInfo userInfo : userInformation) {
            this.putUserInfo(userInfo);
        }
    }

    public void putCalculatingSuppliers() {
        for (DataContainer container : this.values()) {
            container.putSupplier(PerServerKeys.LAST_SEEN, () -> SessionsMutator.forContainer(container).toLastSeen());
            container.putSupplier(PerServerKeys.WORLD_TIMES, () -> SessionsMutator.forContainer(container).toTotalWorldTimes());
            container.putSupplier(PerServerKeys.PLAYER_KILL_COUNT, () -> SessionsMutator.forContainer(container).toPlayerKillCount());
            container.putSupplier(PerServerKeys.MOB_KILL_COUNT, () -> SessionsMutator.forContainer(container).toMobKillCount());
            container.putSupplier(PerServerKeys.DEATH_COUNT, () -> SessionsMutator.forContainer(container).toDeathCount());
        }
    }

    public void putSessions(Collection<Session> sessions) {
        if (sessions == null) {
            return;
        }
        for (Session session : sessions) {
            this.putSession(session);
        }
    }

    private void putSession(Session session) {
        if (session == null) {
            return;
        }
        UUID serverUUID = session.getUnsafe(SessionKeys.SERVER_UUID);
        DataContainer container = this.getOrDefault(serverUUID, new DynamicDataContainer());
        if (!container.supports(PerServerKeys.SESSIONS)) {
            container.putRawData(PerServerKeys.SESSIONS, new ArrayList());
        }
        container.getUnsafe(PerServerKeys.SESSIONS).add(session);
        this.put(serverUUID, container);
    }

    public void putPing(List<Ping> pings) {
        if (pings == null) {
            return;
        }
        for (Ping ping : pings) {
            this.putPing(ping);
        }
    }

    private void putPing(Ping ping) {
        if (ping == null) {
            return;
        }
        UUID serverUUID = ping.getServerUUID();
        DataContainer container = this.getOrDefault(serverUUID, new DynamicDataContainer());
        if (!container.supports(PerServerKeys.PING)) {
            container.putRawData(PerServerKeys.PING, new ArrayList());
        }
        container.getUnsafe(PerServerKeys.PING).add(ping);
        this.put(serverUUID, container);
    }
}

