/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.container;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.keys.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class RawDataContainer
implements DataContainer {
    private final Map<Key, Object> map = new HashMap<Key, Object>();

    @Override
    public <T> void putRawData(Key<T> key, T obj) {
        if (obj == null) {
            return;
        }
        this.map.put(key, obj);
    }

    @Override
    public <T> void putSupplier(Key<T> key, Supplier<T> supplier) {
        if (supplier == null) {
            return;
        }
        this.putRawData(key, supplier.get());
    }

    @Override
    public <T> void putCachingSupplier(Key<T> key, Supplier<T> supplier) {
        this.putSupplier(key, supplier);
    }

    @Override
    public <T> boolean supports(Key<T> key) {
        return this.map.containsKey(key);
    }

    @Override
    public <T> Optional<T> getValue(Key<T> key) {
        try {
            return Optional.ofNullable(key.typeCast(this.map.get(key)));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    public <T> T getUnsafe(Key<T> key) {
        Object value = this.map.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Unsupported Key: " + key.getKeyName());
        }
        return key.typeCast(value);
    }

    @Override
    public void putAll(DataContainer dataContainer) {
        if (dataContainer instanceof RawDataContainer) {
            this.putAll(((RawDataContainer)dataContainer).map);
        } else {
            this.putAll(dataContainer.getMap());
        }
    }

    void putAll(Map<Key, Object> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map<Key, Object> getMap() {
        return this.map;
    }
}

