/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.container;

import com.djrapitops.plan.delivery.domain.container.CachingSupplier;
import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.keys.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class SupplierDataContainer
implements DataContainer {
    private final Map<Key, Supplier> map;
    private final long timeToLive;

    public SupplierDataContainer() {
        this(TimeUnit.SECONDS.toMillis(30L));
    }

    public SupplierDataContainer(long timeToLive) {
        this.timeToLive = timeToLive;
        this.map = new HashMap<Key, Supplier>();
    }

    @Override
    public <T> void putRawData(Key<T> key, T obj) {
        this.putSupplier(key, () -> obj);
    }

    @Override
    public <T> void putSupplier(Key<T> key, Supplier<T> supplier) {
        if (supplier == null) {
            return;
        }
        this.map.put(key, supplier);
    }

    @Override
    public <T> void putCachingSupplier(Key<T> key, Supplier<T> supplier) {
        if (supplier == null) {
            return;
        }
        this.map.put(key, new CachingSupplier<T>(supplier, this.timeToLive));
    }

    private <T> Supplier<T> getSupplier(Key<T> key) {
        return this.map.get(key);
    }

    @Override
    public <T> boolean supports(Key<T> key) {
        return this.map.containsKey(key);
    }

    @Override
    public <T> Optional<T> getValue(Key<T> key) {
        Supplier<T> supplier = this.getSupplier(key);
        if (supplier == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    public <T> T getUnsafe(Key<T> key) {
        Supplier supplier = this.map.get(key);
        if (supplier == null) {
            throw new IllegalArgumentException("Unsupported Key: " + key.getKeyName());
        }
        return key.typeCast(supplier.get());
    }

    private void putAll(Map<Key, Supplier> toPut) {
        this.map.putAll(toPut);
    }

    @Override
    public void putAll(DataContainer dataContainer) {
        if (dataContainer instanceof SupplierDataContainer) {
            this.putAll(((SupplierDataContainer)dataContainer).map);
        } else {
            for (Map.Entry<Key, Object> entry : dataContainer.getMap().entrySet()) {
                this.putRawData(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map<Key, Object> getMap() {
        HashMap<Key, Object> objectMap = new HashMap<Key, Object>();
        for (Map.Entry<Key, Supplier> entry : this.map.entrySet()) {
            objectMap.put(entry.getKey(), entry.getValue().get());
        }
        return objectMap;
    }
}

