/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.HtmlLang;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ActivityIndex {
    public static final double VERY_ACTIVE = 3.75;
    public static final double ACTIVE = 3.0;
    public static final double REGULAR = 2.0;
    public static final double IRREGULAR = 1.0;
    private final double value;
    private final long date;
    private long playtimeMsThreshold;

    public ActivityIndex(DataContainer container, long date, long playtimeMsThreshold) {
        this.playtimeMsThreshold = playtimeMsThreshold;
        this.date = date;
        this.value = this.calculate(container);
    }

    public ActivityIndex(List<Session> sessions, long date, long playtimeMsThreshold) {
        this.playtimeMsThreshold = playtimeMsThreshold;
        this.date = date;
        this.value = this.calculate(new SessionsMutator(sessions));
    }

    public ActivityIndex(double value, long date) {
        this.value = value;
        this.date = date;
    }

    public static String[] getDefaultGroups() {
        return ActivityIndex.getGroups(null);
    }

    public static String[] getGroups(Locale locale) {
        if (locale == null) {
            return new String[]{HtmlLang.INDEX_VERY_ACTIVE.getDefault(), HtmlLang.INDEX_ACTIVE.getDefault(), HtmlLang.INDEX_REGULAR.getDefault(), HtmlLang.INDEX_IRREGULAR.getDefault(), HtmlLang.INDEX_INACTIVE.getDefault()};
        }
        return new String[]{locale.get(HtmlLang.INDEX_VERY_ACTIVE).toString(), locale.get(HtmlLang.INDEX_ACTIVE).toString(), locale.get(HtmlLang.INDEX_REGULAR).toString(), locale.get(HtmlLang.INDEX_IRREGULAR).toString(), locale.get(HtmlLang.INDEX_INACTIVE).toString()};
    }

    private double calculate(DataContainer container) {
        return this.calculate(SessionsMutator.forContainer(container));
    }

    private double calculate(SessionsMutator sessionsMutator) {
        if (sessionsMutator.all().isEmpty()) {
            return 0.0;
        }
        long week = TimeUnit.DAYS.toMillis(7L);
        long weekAgo = this.date - week;
        long twoWeeksAgo = this.date - 2L * week;
        long threeWeeksAgo = this.date - 3L * week;
        SessionsMutator weekOne = sessionsMutator.filterSessionsBetween(weekAgo, this.date);
        SessionsMutator weekTwo = sessionsMutator.filterSessionsBetween(twoWeeksAgo, weekAgo);
        SessionsMutator weekThree = sessionsMutator.filterSessionsBetween(threeWeeksAgo, twoWeeksAgo);
        double playtime1 = weekOne.toActivePlaytime();
        double playtime2 = weekTwo.toActivePlaytime();
        double playtime3 = weekThree.toActivePlaytime();
        double indexW1 = 1.0 / (1.5707963267948966 * (playtime1 / (double)this.playtimeMsThreshold) + 1.0);
        double indexW2 = 1.0 / (1.5707963267948966 * (playtime2 / (double)this.playtimeMsThreshold) + 1.0);
        double indexW3 = 1.0 / (1.5707963267948966 * (playtime3 / (double)this.playtimeMsThreshold) + 1.0);
        double average = (indexW1 + indexW2 + indexW3) / 3.0;
        return 5.0 - 5.0 * average;
    }

    public double getValue() {
        return this.value;
    }

    public long getDate() {
        return this.date;
    }

    public String getFormattedValue(Formatter<Double> formatter) {
        return (String)formatter.apply(this.value);
    }

    public double distance(ActivityIndex other) {
        return Math.abs(Math.log(other.value) - Math.log(this.value));
    }

    public static String getGroup(double value) {
        if (value >= 3.75) {
            return HtmlLang.INDEX_VERY_ACTIVE.getDefault();
        }
        if (value >= 3.0) {
            return HtmlLang.INDEX_ACTIVE.getDefault();
        }
        if (value >= 2.0) {
            return HtmlLang.INDEX_REGULAR.getDefault();
        }
        if (value >= 1.0) {
            return HtmlLang.INDEX_IRREGULAR.getDefault();
        }
        return HtmlLang.INDEX_INACTIVE.getDefault();
    }

    public String getGroup() {
        return ActivityIndex.getGroup(this.value);
    }
}

