/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.DateHolder;
import com.djrapitops.plan.utilities.java.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class DateHoldersMutator<T extends DateHolder> {
    private final List<T> dateHolders;

    public DateHoldersMutator(List<T> dateHolders) {
        this.dateHolders = dateHolders;
    }

    public SortedMap<Long, List<T>> groupByStartOfMinute() {
        TreeMap<Long, List<T>> map = new TreeMap<Long, List<T>>();
        if (this.dateHolders.isEmpty()) {
            return map;
        }
        long sectionLenght = TimeUnit.MINUTES.toMillis(1L);
        for (DateHolder holder : this.dateHolders) {
            long date = holder.getDate();
            long startOfSection = date - date % sectionLenght;
            List list = map.computeIfAbsent(startOfSection, Lists::create);
            list.add(holder);
        }
        return map;
    }

    public SortedMap<Long, List<T>> groupByStartOfDay(TimeZone timeZone) {
        long twentyFourHours = TimeUnit.DAYS.toMillis(1L);
        TreeMap<Long, List<T>> byStart = new TreeMap<Long, List<T>>();
        if (this.dateHolders.isEmpty()) {
            return byStart;
        }
        for (DateHolder holder : this.dateHolders) {
            long date = holder.getDate();
            long dateWithOffset = date + (long)timeZone.getOffset(date);
            long startOfSection = dateWithOffset - dateWithOffset % twentyFourHours;
            List grouped = byStart.computeIfAbsent(startOfSection, Lists::create);
            grouped.add(holder);
        }
        if (!byStart.isEmpty()) {
            long start = byStart.firstKey();
            long now = System.currentTimeMillis();
            long end = now - now % twentyFourHours;
            for (long date = start; date < end; date += twentyFourHours) {
                byStart.putIfAbsent(date, new ArrayList());
            }
        }
        return byStart;
    }
}

