/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.utilities.comparators.GeoInfoComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class GeoInfoMutator {
    private final List<GeoInfo> geoInfo;

    public static GeoInfoMutator forContainer(DataContainer container) {
        return new GeoInfoMutator(container.getValue(PlayerKeys.GEO_INFO).orElse(new ArrayList()));
    }

    public GeoInfoMutator(List<GeoInfo> geoInfo) {
        this.geoInfo = geoInfo;
    }

    public GeoInfoMutator forCollection(Collection<GeoInfo> collection) {
        return new GeoInfoMutator(new ArrayList<GeoInfo>(collection));
    }

    public Optional<GeoInfo> mostRecent() {
        if (this.geoInfo.isEmpty()) {
            return Optional.empty();
        }
        return this.geoInfo.stream().min(new GeoInfoComparator());
    }
}

