/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.rendering.json.graphs.line.Point;
import com.djrapitops.plan.utilities.java.Lists;
import com.djrapitops.plugin.utilities.Verify;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class MutatorFunctions {
    public static List<Point> toPoints(NavigableMap<Long, Integer> map) {
        return Lists.map(map.entrySet(), entry -> new Point((double)((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue()));
    }

    public static NavigableMap<Long, Integer> addMissing(NavigableMap<Long, Integer> points, long accuracy, Integer replacement) {
        if (Verify.isEmpty(points)) {
            return points;
        }
        TreeMap<Long, Integer> filled = new TreeMap<Long, Integer>();
        Long lastX = null;
        for (Map.Entry point : points.entrySet()) {
            long date = (Long)point.getKey();
            if (lastX != null && date - lastX > accuracy) {
                MutatorFunctions.addMissing((long)lastX, date, filled, accuracy, replacement);
            }
            lastX = date;
            filled.put((Long)point.getKey(), (Integer)point.getValue());
        }
        long now = System.currentTimeMillis();
        if (lastX != null && now - lastX > accuracy) {
            MutatorFunctions.addMissing((long)lastX, now, filled, accuracy, replacement);
        }
        return filled;
    }

    private static void addMissing(long from, long to, NavigableMap<Long, Integer> points, long accuracy, Integer replacement) {
        for (long iterate = from; iterate < to; iterate += accuracy) {
            points.putIfAbsent(iterate, replacement);
        }
    }

    public static List<Point> addMissing(List<Point> points, long accuracy, Integer replacement) {
        if (Verify.isEmpty(points)) {
            return points;
        }
        ArrayList<Point> filled = new ArrayList<Point>();
        Long lastX = null;
        for (Point point : points) {
            long date = (long)point.getX();
            if (lastX != null && date - lastX > accuracy) {
                MutatorFunctions.addMissing((long)lastX, date, filled, accuracy, replacement);
            }
            lastX = date;
            filled.add(point);
        }
        return filled;
    }

    private static void addMissing(long from, long to, List<Point> points, long accuracy, Integer replacement) {
        for (long iterate = from; iterate < to; iterate += accuracy) {
            points.add(new Point((double)iterate, replacement.intValue()));
        }
    }

    public static int average(Map<Long, Integer> map) {
        return (int)map.values().stream().mapToInt(i -> i).average().orElse(0.0);
    }

    private MutatorFunctions() {
    }
}

