/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.container.PerServerContainer;
import com.djrapitops.plan.delivery.domain.keys.PerServerKeys;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class PerServerMutator {
    private final PerServerContainer data;

    public PerServerMutator(PerServerContainer data) {
        this.data = data;
    }

    public static PerServerMutator forContainer(DataContainer container) {
        return new PerServerMutator(container.getValue(PlayerKeys.PER_SERVER).orElse(new PerServerContainer()));
    }

    public List<Session> flatMapSessions() {
        return this.data.values().stream().filter(container -> container.supports(PerServerKeys.SESSIONS)).map(container -> container.getValue(PerServerKeys.SESSIONS).orElse(Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public WorldTimes flatMapWorldTimes() {
        WorldTimes total = new WorldTimes();
        for (DataContainer container : this.data.values()) {
            if (!container.supports(PerServerKeys.WORLD_TIMES)) continue;
            WorldTimes worldTimes = container.getUnsafe(PerServerKeys.WORLD_TIMES);
            total.add(worldTimes);
        }
        return total;
    }

    public Map<UUID, WorldTimes> worldTimesPerServer() {
        HashMap<UUID, WorldTimes> timesMap = new HashMap<UUID, WorldTimes>();
        for (Map.Entry entry : this.data.entrySet()) {
            DataContainer container = (DataContainer)entry.getValue();
            timesMap.put((UUID)entry.getKey(), container.getValue(PerServerKeys.WORLD_TIMES).orElse(new WorldTimes()));
        }
        return timesMap;
    }

    public Optional<UUID> favoriteServer() {
        long max = 0L;
        UUID maxServer = null;
        for (Map.Entry entry : this.data.entrySet()) {
            long total = SessionsMutator.forContainer((DataContainer)entry.getValue()).toPlaytime();
            if (total <= max) continue;
            max = total;
            maxServer = (UUID)entry.getKey();
        }
        return Optional.ofNullable(maxServer);
    }

    public Map<UUID, List<Session>> sessionsPerServer() {
        HashMap<UUID, List<Session>> sessionMap = new HashMap<UUID, List<Session>>();
        for (Map.Entry entry : this.data.entrySet()) {
            sessionMap.put((UUID)entry.getKey(), ((DataContainer)entry.getValue()).getValue(PerServerKeys.SESSIONS).orElse(new ArrayList()));
        }
        return sessionMap;
    }

    public boolean isBanned() {
        for (DataContainer container : this.data.values()) {
            if (!container.getValue(PlayerKeys.BANNED).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isOperator() {
        for (DataContainer container : this.data.values()) {
            if (!container.getValue(PlayerKeys.OPERATOR).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

