/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.keys.CommonKeys;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.domain.mutators.DateHoldersMutator;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.utilities.Predicates;
import com.djrapitops.plan.utilities.comparators.DateHolderOldestComparator;
import com.djrapitops.plan.utilities.java.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Predicate;

public class PingMutator {
    private final List<Ping> pings;

    public PingMutator(List<Ping> pings) {
        this.pings = pings;
    }

    public static PingMutator forContainer(DataContainer container) {
        return new PingMutator(container.getValue(CommonKeys.PING).orElse(Collections.emptyList()));
    }

    public PingMutator filterBy(Predicate<Ping> predicate) {
        return new PingMutator(Lists.filter(this.pings, predicate));
    }

    public PingMutator filterByServer(UUID serverUUID) {
        return this.filterBy(ping -> serverUUID.equals(ping.getServerUUID()));
    }

    public PingMutator mutateToByMinutePings() {
        DateHoldersMutator<Ping> dateMutator = new DateHoldersMutator<Ping>(this.pings);
        SortedMap<Long, List<Ping>> byStartOfMinute = dateMutator.groupByStartOfMinute();
        return new PingMutator(Lists.map(byStartOfMinute.entrySet(), entry -> {
            PingMutator mutator = new PingMutator((List)entry.getValue());
            return new Ping((Long)entry.getKey(), null, mutator.min(), mutator.max(), mutator.average());
        }));
    }

    public static Map<UUID, SortedMap<Long, Ping>> sortByServers(List<Ping> pings) {
        HashMap<UUID, SortedMap<Long, Ping>> sorted = new HashMap<UUID, SortedMap<Long, Ping>>();
        for (Ping ping : pings) {
            UUID serverUUID = ping.getServerUUID();
            SortedMap serverSessions = sorted.getOrDefault(serverUUID, new TreeMap());
            serverSessions.put(ping.getDate(), ping);
            sorted.put(serverUUID, serverSessions);
        }
        return sorted;
    }

    public void addPingToSessions(List<Session> sessions) {
        if (sessions.isEmpty()) {
            return;
        }
        DateHolderOldestComparator comparator = new DateHolderOldestComparator();
        sessions.sort(comparator);
        this.pings.sort(comparator);
        Map<UUID, SortedMap<Long, Ping>> pingByServer = PingMutator.sortByServers(this.pings);
        Map<UUID, List<Session>> sessionsByServer = SessionsMutator.sortByServers(sessions);
        for (Map.Entry<UUID, SortedMap<Long, Ping>> entry : pingByServer.entrySet()) {
            UUID serverUUID = entry.getKey();
            SortedMap<Long, Ping> pingOfServer = entry.getValue();
            if (pingOfServer.isEmpty()) continue;
            List sessionsOfServer = sessionsByServer.getOrDefault(serverUUID, Collections.emptyList());
            double pingCount = 0.0;
            int pingEntries = 0;
            for (Session session : sessionsOfServer) {
                long start = session.getDate();
                Long end = session.getValue(SessionKeys.END).orElseGet(System::currentTimeMillis);
                SortedMap<Long, Ping> duringSession = pingOfServer.subMap(start, end);
                for (Ping ping : duringSession.values()) {
                    pingCount += ping.getAverage();
                    ++pingEntries;
                }
                if (pingEntries != 0) {
                    session.putRawData(SessionKeys.AVERAGE_PING, pingCount / (double)pingEntries);
                }
                pingCount = 0.0;
                pingEntries = 0;
            }
        }
    }

    public List<Ping> all() {
        return this.pings;
    }

    public int max() {
        int max = -1;
        for (Ping ping : this.pings) {
            Integer value = ping.getMax();
            if (value <= 0 || 4000 < value || value <= max) continue;
            max = value;
        }
        return max;
    }

    public int min() {
        int min = -1;
        for (Ping ping : this.pings) {
            Integer value = ping.getMin();
            if (value <= 0 || 4000 < value || value >= min && min != -1) continue;
            min = value;
        }
        return min;
    }

    public double average() {
        return this.pings.stream().mapToDouble(Ping::getAverage).filter(Predicates::pingInRange).average().orElse(-1.0);
    }
}

