/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.utilities.java.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlayerKillMutator {
    private final List<PlayerKill> kills;

    public PlayerKillMutator(List<PlayerKill> kills) {
        this.kills = kills;
    }

    public PlayerKillMutator filterNonSelfKills() {
        return new PlayerKillMutator(Lists.filter(this.kills, PlayerKill::isNotSelfKill));
    }

    public List<Map<String, Object>> toJSONAsMap(Formatters formatters) {
        return Lists.map(this.kills, kill -> {
            HashMap<String, Object> killMap = new HashMap<String, Object>();
            killMap.put("date", formatters.secondLong().apply(kill.getDate()));
            killMap.put("victim", kill.getVictimName().orElse(kill.getVictim().toString()));
            killMap.put("killer", kill.getKillerName().orElse("Missing UUID"));
            killMap.put("weapon", kill.getWeapon());
            return killMap;
        });
    }
}

