/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.utilities.Predicates;
import com.djrapitops.plan.utilities.java.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PlayerVersusMutator {
    private final SessionsMutator sessionsMutator;
    private final List<PlayerKill> kills;
    private final List<PlayerKill> deaths;

    public PlayerVersusMutator(SessionsMutator sessionsMutator, List<PlayerKill> kills, List<PlayerKill> deaths) {
        this.sessionsMutator = sessionsMutator;
        this.kills = kills;
        this.deaths = deaths;
    }

    public static PlayerVersusMutator forContainer(DataContainer container) {
        return new PlayerVersusMutator(SessionsMutator.forContainer(container), container.getValue(PlayerKeys.PLAYER_KILLS).orElse(Collections.emptyList()), container.getValue(PlayerKeys.PLAYER_DEATHS_KILLS).orElse(Collections.emptyList()));
    }

    public PlayerVersusMutator filterBetween(long after, long before) {
        Predicate killWithinDate = Predicates.within(after, before);
        return new PlayerVersusMutator(this.sessionsMutator.filterSessionsBetween(after, before), Lists.filter(this.kills, killWithinDate), Lists.filter(this.deaths, killWithinDate));
    }

    public int toPlayerKillCount() {
        return this.kills.size();
    }

    public int toMobKillCount() {
        return this.sessionsMutator.toMobKillCount();
    }

    public double toKillDeathRatio() {
        int deathCount = this.toPlayerDeathCount();
        return (double)this.toPlayerKillCount() * 1.0 / (double)(deathCount != 0 ? deathCount : 1);
    }

    public double toMobKillDeathRatio() {
        int deathCount = this.toMobDeathCount();
        return (double)this.toMobKillCount() * 1.0 / (double)(deathCount != 0 ? deathCount : 1);
    }

    public int toPlayerDeathCount() {
        return this.deaths.size();
    }

    public int toMobDeathCount() {
        return this.toDeathCount() - this.toPlayerDeathCount();
    }

    public int toDeathCount() {
        return this.sessionsMutator.toDeathCount();
    }

    public List<String> toTopWeapons(int limit) {
        return this.kills.stream().map(PlayerKill::getWeapon).collect(HashMap::new, (map, weapon) -> map.put(weapon, map.getOrDefault(weapon, 0) + 1), (mapOne, mapTwo) -> {}).entrySet().stream().sorted((one, two) -> Integer.compare((Integer)two.getValue(), (Integer)one.getValue())).limit(limit).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

