/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.DateObj;
import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.keys.ServerKeys;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.delivery.domain.mutators.DateHoldersMutator;
import com.djrapitops.plan.delivery.domain.mutators.GeoInfoMutator;
import com.djrapitops.plan.delivery.domain.mutators.MutatorFunctions;
import com.djrapitops.plan.delivery.domain.mutators.PingMutator;
import com.djrapitops.plan.delivery.domain.mutators.PlayersOnlineResolver;
import com.djrapitops.plan.delivery.domain.mutators.RetentionData;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.utilities.java.Lists;
import com.djrapitops.plan.utilities.java.Maps;
import com.djrapitops.plugin.api.TimeAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PlayersMutator {
    private final List<PlayerContainer> players;

    public PlayersMutator(List<PlayerContainer> players) {
        this.players = players;
    }

    public static PlayersMutator copyOf(PlayersMutator mutator) {
        return new PlayersMutator(new ArrayList<PlayerContainer>(mutator.players));
    }

    public static PlayersMutator forContainer(DataContainer container) {
        return new PlayersMutator(container.getValue(ServerKeys.PLAYERS).orElse(new ArrayList()));
    }

    public <T extends Predicate<PlayerContainer>> PlayersMutator filterBy(T by) {
        return new PlayersMutator(Lists.filter(this.players, by));
    }

    public PlayersMutator filterPlayedBetween(long after, long before) {
        return this.filterBy(player -> player.getValue(PlayerKeys.SESSIONS).map(sessions -> sessions.stream().anyMatch(session -> {
            long start = session.getValue(SessionKeys.START).orElse(-1L);
            long end = session.getValue(SessionKeys.END).orElse(-1L);
            return after <= start && start <= before || after <= end && end <= before;
        })).orElse(false));
    }

    public PlayersMutator filterRegisteredBetween(long after, long before) {
        return this.filterBy(player -> player.getValue(PlayerKeys.REGISTERED).map(date -> after <= date && date <= before).orElse(false));
    }

    public PlayersMutator filterRetained(long after, long before) {
        return this.filterBy(player -> {
            long backLimit = Math.max(after, player.getValue(PlayerKeys.REGISTERED).orElse(0L));
            long half = backLimit + (before - backLimit) / 2L;
            SessionsMutator sessionsMutator = SessionsMutator.forContainer(player);
            return sessionsMutator.playedBetween(backLimit, half) && sessionsMutator.playedBetween(half, before);
        });
    }

    public PlayersMutator filterActive(long date, long msThreshold, double limit) {
        return this.filterBy(player -> player.getActivityIndex(date, msThreshold).getValue() >= limit);
    }

    public PlayersMutator filterPlayedOnServer(UUID serverUUID) {
        return this.filterBy(player -> !SessionsMutator.forContainer(player).filterPlayedOnServer(serverUUID).all().isEmpty());
    }

    public List<PlayerContainer> all() {
        return this.players;
    }

    public List<Long> registerDates() {
        ArrayList<Long> registerDates = new ArrayList<Long>();
        for (PlayerContainer player : this.players) {
            registerDates.add(player.getValue(PlayerKeys.REGISTERED).orElse(-1L));
        }
        return registerDates;
    }

    public List<String> getGeolocations() {
        ArrayList<String> geolocations = new ArrayList<String>();
        for (PlayerContainer player : this.players) {
            Optional<GeoInfo> mostRecent = GeoInfoMutator.forContainer(player).mostRecent();
            geolocations.add(mostRecent.map(GeoInfo::getGeolocation).orElse("Unknown"));
        }
        return geolocations;
    }

    public Map<String, List<Ping>> getPingPerCountry(UUID serverUUID) {
        HashMap<String, List<Ping>> pingPerCountry = new HashMap<String, List<Ping>>();
        for (PlayerContainer player : this.players) {
            Optional<GeoInfo> mostRecent = GeoInfoMutator.forContainer(player).mostRecent();
            if (!mostRecent.isPresent()) continue;
            List pings = player.getValue(PlayerKeys.PING).orElse(new ArrayList());
            String country = mostRecent.get().getGeolocation();
            List countryPings = pingPerCountry.computeIfAbsent(country, Lists::create);
            countryPings.addAll(new PingMutator(pings).filterByServer(serverUUID).all());
        }
        return pingPerCountry;
    }

    public TreeMap<Long, Map<String, Set<UUID>>> toActivityDataMap(long date, long msThreshold) {
        TreeMap<Long, Map<String, Set<UUID>>> activityData = new TreeMap<Long, Map<String, Set<UUID>>>();
        for (long time = date; time >= date - TimeAmount.MONTH.toMillis(2L); time -= TimeAmount.WEEK.toMillis(1L)) {
            Map map = activityData.computeIfAbsent(time, Maps::create);
            if (this.players.isEmpty()) continue;
            for (PlayerContainer player : this.players) {
                if (player.getValue(PlayerKeys.REGISTERED).orElse(0L) > time) continue;
                ActivityIndex activityIndex = player.getActivityIndex(time, msThreshold);
                String activityGroup = activityIndex.getGroup();
                Set uuids = map.computeIfAbsent(activityGroup, Maps::createSet);
                uuids.add(player.getUnsafe(PlayerKeys.UUID));
            }
        }
        return activityData;
    }

    public int count() {
        return this.players.size();
    }

    public int averageNewPerDay(TimeZone timeZone) {
        return MutatorFunctions.average(this.newPerDay(timeZone));
    }

    public TreeMap<Long, Integer> newPerDay(TimeZone timeZone) {
        List<DateObj> registerDates = Lists.map(this.registerDates(), value -> new DateObj<Long>((long)value, (Long)value));
        SortedMap<Long, List<DateObj>> byDay = new DateHoldersMutator<DateObj>(registerDates).groupByStartOfDay(timeZone);
        TreeMap<Long, Integer> byDayCounts = new TreeMap<Long, Integer>();
        for (Map.Entry<Long, List<DateObj>> entry : byDay.entrySet()) {
            byDayCounts.put(entry.getKey(), entry.getValue().size());
        }
        return byDayCounts;
    }

    public PlayersMutator compareAndFindThoseLikelyToBeRetained(Iterable<PlayerContainer> compareTo, long dateLimit, PlayersOnlineResolver onlineResolver, long activityMsThreshold) {
        ArrayList<PlayerContainer> retainedAfterMonth = new ArrayList<PlayerContainer>();
        ArrayList<PlayerContainer> notRetainedAfterMonth = new ArrayList<PlayerContainer>();
        for (PlayerContainer player2 : this.players) {
            long registered = player2.getValue(PlayerKeys.REGISTERED).orElse(System.currentTimeMillis());
            if (registered > dateLimit) continue;
            long monthAfterRegister = registered + TimeAmount.MONTH.toMillis(1L);
            long half = registered + TimeAmount.MONTH.toMillis(1L) / 2L;
            if (player2.playedBetween(registered, half) && player2.playedBetween(half, monthAfterRegister)) {
                retainedAfterMonth.add(player2);
                continue;
            }
            notRetainedAfterMonth.add(player2);
        }
        if (retainedAfterMonth.isEmpty() || notRetainedAfterMonth.isEmpty()) {
            throw new IllegalStateException("No players to compare to after rejecting with dateLimit");
        }
        Function<PlayerContainer, RetentionData> mapper = player -> new RetentionData((PlayerContainer)player, onlineResolver, activityMsThreshold);
        List<RetentionData> retained = Lists.map(retainedAfterMonth, mapper);
        List<RetentionData> notRetained = Lists.map(notRetainedAfterMonth, mapper);
        RetentionData avgRetained = RetentionData.average(retained);
        RetentionData avgNotRetained = RetentionData.average(notRetained);
        ArrayList<PlayerContainer> toBeRetained = new ArrayList<PlayerContainer>();
        for (PlayerContainer player3 : compareTo) {
            RetentionData retentionData = new RetentionData(player3, onlineResolver, activityMsThreshold);
            if (!(retentionData.distance(avgRetained) < retentionData.distance(avgNotRetained))) continue;
            toBeRetained.add(player3);
        }
        return new PlayersMutator(toBeRetained);
    }

    public List<Session> getSessions() {
        return this.players.stream().map(player -> player.getValue(PlayerKeys.SESSIONS).orElse(new ArrayList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<UUID> uuids() {
        return this.players.stream().map(player -> player.getValue(PlayerKeys.UUID).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<PlayerContainer> operators() {
        return Lists.filter(this.players, player -> player.getValue(PlayerKeys.OPERATOR).orElse(false));
    }

    public List<Ping> pings() {
        return this.players.stream().map(player -> player.getValue(PlayerKeys.PING).orElse(new ArrayList())).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

