/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.mutators.TPSMutator;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.Point;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class PlayersOnlineResolver
extends TreeMap<Long, Integer> {
    public PlayersOnlineResolver(TPSMutator mutator) {
        List<Point> points = mutator.playersOnlinePoints();
        for (Point point : points) {
            double date = point.getX();
            double value = point.getY();
            this.put((long)date, (int)value);
        }
    }

    public Optional<Integer> getOnlineOn(long date) {
        Map.Entry entry = this.floorEntry(date);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry.getValue());
    }

    public int findLonelyJoins(List<Long> joinDates) {
        int lonely = 0;
        for (Long joinDate : joinDates) {
            if (this.getOnlineOn(joinDate).orElse(-1) != 0) continue;
            ++lonely;
        }
        return lonely;
    }

    public boolean isServerOnline(long date, long timeLimit) {
        Long lastEntry = this.floorKey(date);
        return date - lastEntry < timeLimit;
    }
}

