/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.delivery.domain.mutators.PlayersOnlineResolver;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class RetentionData {
    private final double activityIndex;
    private final double onlineOnJoin;

    public static RetentionData average(Collection<RetentionData> stuck) {
        int size = stuck.size();
        double totalIndex = 0.0;
        double totalPlayersOnline = 0.0;
        for (RetentionData retentionData : stuck) {
            totalIndex += retentionData.getActivityIndex();
            totalPlayersOnline += retentionData.getOnlineOnJoin();
        }
        double averageIndex = totalIndex / (double)size;
        double averagePlayersOnline = totalPlayersOnline / (double)size;
        return new RetentionData(averageIndex, averagePlayersOnline);
    }

    public RetentionData(double activityIndex, double onlineOnJoin) {
        this.activityIndex = activityIndex;
        this.onlineOnJoin = onlineOnJoin;
    }

    public RetentionData(PlayerContainer player, PlayersOnlineResolver onlineOnJoin, long activityMsThreshold) {
        Optional<Long> registeredValue = player.getValue(PlayerKeys.REGISTERED);
        this.activityIndex = registeredValue.map(registered -> new ActivityIndex(player, registered + TimeUnit.DAYS.toMillis(1L), activityMsThreshold).getValue()).orElse(0.0);
        this.onlineOnJoin = registeredValue.map(registered -> onlineOnJoin.getOnlineOn((long)registered).orElse(-1)).orElse(0).intValue();
    }

    public static int countRetentionPrediction(Collection<ActivityIndex> newPlayers, ActivityIndex retained, ActivityIndex nonRetained) {
        int count = 0;
        for (ActivityIndex player : newPlayers) {
            if (!(player.distance(retained) < player.distance(nonRetained))) continue;
            ++count;
        }
        return count;
    }

    public double distance(RetentionData data) {
        double num = 0.0;
        num += Math.abs(data.activityIndex - this.activityIndex) * 2.0;
        return num += data.onlineOnJoin != -1.0 && this.onlineOnJoin != -1.0 ? Math.abs(data.onlineOnJoin - this.onlineOnJoin) / 10.0 : 0.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetentionData that = (RetentionData)o;
        return Double.compare(that.activityIndex, this.activityIndex) == 0 && Double.compare(that.onlineOnJoin, this.onlineOnJoin) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.activityIndex, this.onlineOnJoin);
    }

    public double getOnlineOnJoin() {
        return this.onlineOnJoin;
    }

    public double getActivityIndex() {
        return this.activityIndex;
    }
}

