/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.mutators;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.keys.ServerKeys;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.Point;
import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.utilities.comparators.TPSComparator;
import com.djrapitops.plan.utilities.java.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TPSMutator {
    private final List<TPS> tpsData;

    public TPSMutator(List<TPS> tpsData) {
        this.tpsData = tpsData;
    }

    public static TPSMutator forContainer(DataContainer container) {
        return new TPSMutator(container.getValue(ServerKeys.TPS).orElse(new ArrayList()));
    }

    public static TPSMutator copyOf(TPSMutator mutator) {
        return new TPSMutator(new ArrayList<TPS>(mutator.tpsData));
    }

    public TPSMutator filterBy(Predicate<TPS> filter) {
        return new TPSMutator(Lists.filter(this.tpsData, filter));
    }

    public TPSMutator filterDataBetween(long after, long before) {
        return this.filterBy(tps -> tps.getDate() >= after && tps.getDate() <= before);
    }

    public TPSMutator filterTPSBetween(int above, int below) {
        return this.filterBy(tps -> tps.getTicksPerSecond() > (double)above && tps.getTicksPerSecond() < (double)below);
    }

    public List<TPS> all() {
        return this.tpsData;
    }

    public List<Point> playersOnlinePoints() {
        return Lists.map(this.tpsData, tps -> new Point((double)tps.getDate(), tps.getPlayers()));
    }

    public List<Point> tpsPoints() {
        return Lists.map(this.tpsData, tps -> new Point((double)tps.getDate(), tps.getTicksPerSecond()));
    }

    public List<Point> cpuPoints() {
        return this.tpsData.stream().map(tps -> new Point((double)tps.getDate(), tps.getCPUUsage())).filter(point -> point.getY() != -1.0).collect(Collectors.toList());
    }

    public List<Point> ramUsagePoints() {
        return Lists.map(this.tpsData, tps -> new Point((double)tps.getDate(), tps.getUsedMemory()));
    }

    public List<Point> entityPoints() {
        return Lists.map(this.tpsData, tps -> new Point((double)tps.getDate(), tps.getEntityCount()));
    }

    public List<Point> chunkPoints() {
        return Lists.map(this.tpsData, tps -> new Point((double)tps.getDate(), tps.getChunksLoaded()));
    }

    public List<Point> freeDiskPoints() {
        return this.tpsData.stream().map(tps -> new Point((double)tps.getDate(), tps.getFreeDiskSpace())).filter(point -> point.getY() != -1.0).collect(Collectors.toList());
    }

    public long serverDownTime() {
        long lastDate = -1L;
        long downTime = 0L;
        this.tpsData.sort(new TPSComparator());
        for (TPS tps : this.tpsData) {
            long date = tps.getDate();
            if (lastDate == -1L) {
                lastDate = date;
                continue;
            }
            long diff = date - lastDate;
            if (diff > TimeUnit.MINUTES.toMillis(3L)) {
                downTime += diff;
            }
            lastDate = date;
        }
        return downTime;
    }

    public long serverOccupiedTime() {
        long lastDate = -1L;
        long activeTime = 0L;
        this.tpsData.sort(new TPSComparator());
        for (TPS tps : this.tpsData) {
            long date = tps.getDate();
            if (lastDate == -1L) {
                lastDate = date;
                continue;
            }
            int players = tps.getPlayers();
            long diff = date - lastDate;
            if (players > 0 && diff <= TimeUnit.MINUTES.toMillis(3L)) {
                activeTime += diff;
            }
            lastDate = date;
        }
        return activeTime;
    }

    public double percentageTPSAboveThreshold(int threshold) {
        if (this.tpsData.isEmpty()) {
            return 1.0;
        }
        long count = 0L;
        for (TPS tps : this.tpsData) {
            if (!(tps.getTicksPerSecond() >= (double)threshold)) continue;
            ++count;
        }
        return (double)count * 1.0 / (double)this.tpsData.size();
    }

    public int lowTpsSpikeCount(int threshold) {
        boolean wasLow = false;
        int spikeCount = 0;
        for (TPS tpsObj : this.tpsData) {
            double tps = tpsObj.getTicksPerSecond();
            if (tps < (double)threshold) {
                if (wasLow) continue;
                ++spikeCount;
                wasLow = true;
                continue;
            }
            wasLow = false;
        }
        return spikeCount;
    }

    public double averageTPS() {
        return this.tpsData.stream().mapToDouble(TPS::getTicksPerSecond).filter(num -> num >= 0.0).average().orElse(-1.0);
    }

    public double averageCPU() {
        return this.tpsData.stream().mapToDouble(TPS::getCPUUsage).filter(num -> num >= 0.0).average().orElse(-1.0);
    }

    public double averageRAM() {
        return this.tpsData.stream().mapToDouble(TPS::getUsedMemory).filter(num -> num >= 0.0).average().orElse(-1.0);
    }

    public double averageEntities() {
        return this.tpsData.stream().mapToDouble(TPS::getEntityCount).filter(num -> num >= 0.0).average().orElse(-1.0);
    }

    public double averageChunks() {
        return this.tpsData.stream().mapToDouble(TPS::getChunksLoaded).filter(num -> num >= 0.0).average().orElse(-1.0);
    }

    public double averageFreeDisk() {
        return this.tpsData.stream().mapToDouble(TPS::getFreeDiskSpace).filter(num -> num >= 0.0).average().orElse(-1.0);
    }

    public long maxFreeDisk() {
        return this.tpsData.stream().mapToLong(TPS::getFreeDiskSpace).filter(num -> num >= 0L).max().orElse(-1L);
    }

    public long minFreeDisk() {
        return this.tpsData.stream().mapToLong(TPS::getFreeDiskSpace).filter(num -> num >= 0L).min().orElse(-1L);
    }

    public double averagePlayersOnline() {
        return this.tpsData.stream().mapToDouble(TPS::getPlayers).average().orElse(-1.0);
    }

    public Optional<TPS> getLast() {
        if (this.tpsData.isEmpty()) {
            return Optional.empty();
        }
        this.tpsData.sort(new TPSComparator());
        return Optional.of(this.tpsData.get(this.tpsData.size() - 1));
    }
}

