/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.TaskSystem;
import com.djrapitops.plan.delivery.export.ExportTask;
import com.djrapitops.plan.delivery.export.Exporter;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.ExportSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ExportScheduler {
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final TaskSystem taskSystem;
    private final Exporter exporter;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;

    @Inject
    public ExportScheduler(PlanConfig config, DBSystem dbSystem, TaskSystem taskSystem, Exporter exporter, PluginLogger logger, ErrorLogger errorLogger) {
        this.config = config;
        this.dbSystem = dbSystem;
        this.taskSystem = taskSystem;
        this.exporter = exporter;
        this.logger = logger;
        this.errorLogger = errorLogger;
    }

    public void scheduleExport() {
        this.scheduleServerPageExport();
        this.schedulePlayersPageExport();
    }

    private void schedulePlayersPageExport() {
        long period = TimeAmount.toTicks(this.config.get(ExportSettings.EXPORT_PERIOD), TimeUnit.MILLISECONDS);
        this.taskSystem.registerTask("Players page export", new ExportTask(this.exporter, Exporter::exportPlayersPage, this.errorLogger)).runTaskTimerAsynchronously(0L, period);
    }

    private void scheduleServerPageExport() {
        if (this.config.isFalse(ExportSettings.SERVER_PAGE)) {
            return;
        }
        Collection<Server> servers = this.dbSystem.getDatabase().query(ServerQueries.fetchPlanServerInformationCollection());
        int serverCount = servers.size();
        if (serverCount == 0) {
            return;
        }
        long period = TimeAmount.toTicks(this.config.get(ExportSettings.EXPORT_PERIOD), TimeUnit.MILLISECONDS);
        long offset = period / (long)serverCount;
        Optional<Server> proxy = servers.stream().filter(Server::isProxy).findFirst();
        proxy.ifPresent(mainServer -> this.taskSystem.registerTask("Network export", new ExportTask(this.exporter, exporter -> exporter.exportServerPage((Server)mainServer), this.errorLogger)).runTaskTimerAsynchronously(0L, period));
        int offsetMultiplier = proxy.isPresent() ? 1 : 0;
        for (Server server : servers) {
            this.taskSystem.registerTask("Server export", new ExportTask(this.exporter, same -> {
                same.exportServerPage(server);
                same.exportServerJSON(server);
            }, this.errorLogger)).runTaskTimerAsynchronously(offset * (long)offsetMultiplier, period);
            ++offsetMultiplier;
        }
    }
}

