/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.delivery.export.ExportScheduler;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ExportSystem
implements SubSystem {
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final ExportScheduler exportScheduler;

    @Inject
    public ExportSystem(DBSystem dbSystem, ServerInfo serverInfo, ExportScheduler exportScheduler) {
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.exportScheduler = exportScheduler;
    }

    @Override
    public void enable() {
        Database database = this.dbSystem.getDatabase();
        boolean hasProxy = database.query(ServerQueries.fetchProxyServerInformation()).isPresent();
        if (this.serverInfo.getServer().isNotProxy() && hasProxy) {
            return;
        }
        this.exportScheduler.scheduleExport();
    }

    @Override
    public void disable() {
    }
}

