/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.delivery.export.Exporter;
import com.djrapitops.plan.exceptions.ExportException;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.utilities.java.ThrowingConsumer;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.task.AbsRunnable;

public class ExportTask
extends AbsRunnable {
    private final Exporter exporter;
    private final ThrowingConsumer<Exporter, ExportException> exportAction;
    private final ErrorLogger errorLogger;

    public ExportTask(Exporter exporter, ThrowingConsumer<Exporter, ExportException> exportAction, ErrorLogger errorLogger) {
        this.exporter = exporter;
        this.exportAction = exportAction;
        this.errorLogger = errorLogger;
    }

    @Override
    public void run() {
        try {
            this.exportAction.accept(this.exporter);
        }
        catch (ExportException e) {
            this.errorLogger.log(L.WARN, e, ErrorContext.builder().related((Object)"Export task run").build());
        }
        catch (DBOpException dbException) {
            this.handleDBException(dbException);
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo("Export Task Disabled due to error - reload Plan to re-enable.").related((Object)"Export task run").build());
            this.cancel();
        }
    }

    private void handleDBException(DBOpException dbException) {
        if (dbException.getMessage().contains("closed")) {
            this.errorLogger.log(L.ERROR, dbException, ErrorContext.builder().whatToDo("Export Task Disabled due to error - database is closing, so this error can be ignored.).").related((Object)"Export task run").build());
        } else {
            this.errorLogger.log(L.ERROR, dbException, ErrorContext.builder().whatToDo("Export Task Disabled due to error - reload Plan to re-enable.").related((Object)"Export task run").build());
        }
        this.cancel();
    }
}

