/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.delivery.export.ExportPaths;
import com.djrapitops.plan.delivery.export.FileExporter;
import com.djrapitops.plan.delivery.export.NetworkPageExporter;
import com.djrapitops.plan.delivery.export.PlayerJSONExporter;
import com.djrapitops.plan.delivery.export.PlayerPageExporter;
import com.djrapitops.plan.delivery.export.PlayersPageExporter;
import com.djrapitops.plan.delivery.export.ServerPageExporter;
import com.djrapitops.plan.delivery.web.resolver.exception.NotFoundException;
import com.djrapitops.plan.exceptions.ExportException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.ExportSettings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class Exporter
extends FileExporter {
    private final PlanConfig config;
    private final PlayerJSONExporter playerJSONExporter;
    private final PlayerPageExporter playerPageExporter;
    private final PlayersPageExporter playersPageExporter;
    private final ServerPageExporter serverPageExporter;
    private final NetworkPageExporter networkPageExporter;
    private final Set<UUID> failedServers;

    @Inject
    public Exporter(PlanConfig config, PlayerJSONExporter playerJSONExporter, PlayerPageExporter playerPageExporter, PlayersPageExporter playersPageExporter, ServerPageExporter serverPageExporter, NetworkPageExporter networkPageExporter) {
        this.config = config;
        this.playerJSONExporter = playerJSONExporter;
        this.playerPageExporter = playerPageExporter;
        this.playersPageExporter = playersPageExporter;
        this.serverPageExporter = serverPageExporter;
        this.networkPageExporter = networkPageExporter;
        this.failedServers = new HashSet<UUID>();
    }

    public boolean exportServerPage(Server server) throws ExportException {
        UUID serverUUID = server.getUuid();
        if (this.failedServers.contains(serverUUID) || this.config.isFalse(ExportSettings.SERVER_PAGE)) {
            return false;
        }
        try {
            Path toDirectory = this.config.getPageExportPath();
            if (server.isProxy()) {
                this.networkPageExporter.export(toDirectory, server);
            } else {
                this.serverPageExporter.export(toDirectory, server);
            }
            return true;
        }
        catch (NotFoundException | IOException e) {
            this.failedServers.add(serverUUID);
            throw new ExportException("Failed to export server: " + server.getIdentifiableName() + " (Attempts disabled until next reload), " + e.toString(), e);
        }
    }

    public boolean exportServerJSON(Server server) throws ExportException {
        UUID serverUUID = server.getUuid();
        if (this.failedServers.contains(serverUUID) || this.config.isFalse(ExportSettings.SERVER_JSON)) {
            return false;
        }
        try {
            Path toDirectory = this.config.getJSONExportPath().resolve(this.toFileName(server.getName()));
            if (server.isProxy()) {
                this.networkPageExporter.exportJSON(new ExportPaths(), toDirectory, server);
            } else {
                this.serverPageExporter.exportJSON(toDirectory, server);
            }
            return true;
        }
        catch (NotFoundException | IOException e) {
            this.failedServers.add(serverUUID);
            throw new ExportException("Failed to export server: " + server.getIdentifiableName() + " (Attempts disabled until next reload), " + e.toString(), e);
        }
    }

    public boolean exportPlayerPage(UUID playerUUID, String playerName) throws ExportException {
        Path toDirectory = this.config.getPageExportPath();
        if (this.config.isFalse(ExportSettings.PLAYER_PAGES)) {
            return false;
        }
        try {
            this.playerPageExporter.export(toDirectory, playerUUID, playerName);
            return true;
        }
        catch (NotFoundException | IOException e) {
            throw new ExportException("Failed to export player: " + playerName + ", " + e.toString(), e);
        }
    }

    public boolean exportPlayersPage() throws ExportException {
        Path toDirectory = this.config.getPageExportPath();
        if (this.config.isFalse(ExportSettings.PLAYERS_PAGE)) {
            return false;
        }
        try {
            this.playersPageExporter.export(toDirectory);
            return true;
        }
        catch (NotFoundException | IOException e) {
            throw new ExportException("Failed to export players page, " + e.toString(), e);
        }
    }

    public boolean exportPlayerJSON(UUID playerUUID, String playerName) throws ExportException {
        Path toDirectory = this.config.getJSONExportPath();
        if (this.config.isFalse(ExportSettings.PLAYER_JSON)) {
            return false;
        }
        try {
            this.playerJSONExporter.export(toDirectory, playerUUID, playerName);
            return true;
        }
        catch (IOException e) {
            throw new ExportException("Failed to export player: " + playerName + ", " + e.toString(), e);
        }
    }
}

