/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.web.resource.WebResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import plan.org.apache.commons.lang3.StringUtils;

abstract class FileExporter {
    private static final OpenOption[] OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};

    FileExporter() {
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] bytes = new byte[1024];
        while ((read = in.read(bytes)) != -1) {
            out.write(bytes, 0, read);
        }
    }

    void export(Path to, List<String> content) throws IOException {
        Files.createDirectories(to.getParent(), new FileAttribute[0]);
        Files.write(to, content, StandardCharsets.UTF_8, OPEN_OPTIONS);
    }

    void export(Path to, String content) throws IOException {
        this.export(to, Arrays.asList(StringUtils.split(content, "\r\n")));
    }

    void export(Path to, WebResource resource) throws IOException {
        Files.createDirectories(to.getParent(), new FileAttribute[0]);
        try (InputStream in = resource.asStream();
             OutputStream out = Files.newOutputStream(to, OPEN_OPTIONS);){
            FileExporter.copy(in, out);
        }
    }

    void export(Path to, byte[] resource) throws IOException {
        Files.createDirectories(to.getParent(), new FileAttribute[0]);
        try (ByteArrayInputStream in = new ByteArrayInputStream(resource);
             OutputStream out = Files.newOutputStream(to, OPEN_OPTIONS);){
            FileExporter.copy(in, out);
        }
    }

    String toFileName(String resourceName) {
        return StringUtils.replaceEach(Html.encodeToURL(resourceName), new String[]{".", "%2F", "%20"}, new String[]{"%2E", "-", " "});
    }
}

