/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.delivery.export.ExportPaths;
import com.djrapitops.plan.delivery.export.FileExporter;
import com.djrapitops.plan.delivery.rendering.pages.NetworkPage;
import com.djrapitops.plan.delivery.rendering.pages.PageFactory;
import com.djrapitops.plan.delivery.web.ResourceService;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.exception.NotFoundException;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resource.WebResource;
import com.djrapitops.plan.delivery.webserver.resolver.json.RootJSONResolver;
import com.djrapitops.plan.exceptions.connection.WebException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.storage.file.Resource;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;

@Singleton
public class NetworkPageExporter
extends FileExporter {
    private final PlanFiles files;
    private final DBSystem dbSystem;
    private final PageFactory pageFactory;
    private final RootJSONResolver jsonHandler;
    private final Theme theme;

    @Inject
    public NetworkPageExporter(PlanFiles files, DBSystem dbSystem, PageFactory pageFactory, RootJSONResolver jsonHandler, Theme theme) {
        this.files = files;
        this.dbSystem = dbSystem;
        this.pageFactory = pageFactory;
        this.jsonHandler = jsonHandler;
        this.theme = theme;
    }

    public void export(Path toDirectory, Server server) throws IOException {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState == Database.State.CLOSED || dbState == Database.State.CLOSING) {
            return;
        }
        ExportPaths exportPaths = new ExportPaths();
        exportPaths.put("./players", this.toRelativePathFromRoot("players"));
        this.exportRequiredResources(exportPaths, toDirectory);
        this.exportJSON(exportPaths, toDirectory, server);
        this.exportHtml(exportPaths, toDirectory);
    }

    private void exportHtml(ExportPaths exportPaths, Path toDirectory) throws IOException {
        Path to = toDirectory.resolve("network").resolve("index.html");
        NetworkPage page = this.pageFactory.networkPage();
        this.export(to, exportPaths.resolveExportPaths(page.toHtml()));
    }

    public void exportJSON(ExportPaths exportPaths, Path toDirectory, Server server) throws IOException {
        String serverUUID = server.getUuid().toString();
        this.exportJSON(exportPaths, toDirectory, "network/overview", "network/servers", "network/sessionsOverview", "network/playerbaseOverview", "graph?type=playersOnline&server=" + serverUUID, "graph?type=uniqueAndNew", "graph?type=serverPie", "graph?type=activity", "graph?type=geolocation", "graph?type=uniqueAndNew", "network/pingTable", "sessions");
    }

    private void exportJSON(ExportPaths exportPaths, Path toDirectory, String ... resources) throws IOException {
        for (String resource : resources) {
            this.exportJSON(exportPaths, toDirectory, resource);
        }
    }

    private void exportJSON(ExportPaths exportPaths, Path toDirectory, String resource) throws IOException {
        Optional<Response> found = this.getJSONResponse(resource);
        if (!found.isPresent()) {
            throw new NotFoundException(resource + " was not properly exported: not found");
        }
        String jsonResourceName = this.toFileName(this.toJSONResourceName(resource)) + ".json";
        String relativePlayerLink = this.toRelativePathFromRoot("player");
        this.export(toDirectory.resolve("data").resolve(jsonResourceName), StringUtils.replaceEach(found.get().getAsString(), new String[]{"../player", "./player"}, new String[]{relativePlayerLink, relativePlayerLink}));
        exportPaths.put("./v1/" + resource, this.toRelativePathFromRoot("data/" + jsonResourceName));
    }

    private String toJSONResourceName(String resource) {
        return StringUtils.replaceEach(resource, new String[]{"?", "&", "type=", "server="}, new String[]{"-", "_", "", ""});
    }

    private Optional<Response> getJSONResponse(String resource) {
        try {
            return this.jsonHandler.getResolver().resolve(new Request("GET", "/v1/" + resource, null, Collections.emptyMap()));
        }
        catch (WebException e) {
            throw new IllegalStateException("Unexpected exception thrown: " + e.toString(), e);
        }
    }

    private void exportRequiredResources(ExportPaths exportPaths, Path toDirectory) throws IOException {
        this.exportResources(exportPaths, toDirectory, "./img/Flaticon_circle.png", "./css/sb-admin-2.css", "./css/style.css", "./vendor/jquery/jquery.min.js", "./vendor/bootstrap/js/bootstrap.bundle.min.js", "./vendor/datatables/jquery.dataTables.min.js", "./vendor/datatables/dataTables.bootstrap4.min.js", "./vendor/highcharts/highstock.js", "./vendor/highcharts/map.js", "./vendor/highcharts/world.js", "./vendor/highcharts/drilldown.js", "./vendor/highcharts/highcharts-more.js", "./vendor/highcharts/no-data-to-display.js", "./vendor/fontawesome-free/css/all.min.css", "./vendor/fontawesome-free/webfonts/fa-brands-400.eot", "./vendor/fontawesome-free/webfonts/fa-brands-400.ttf", "./vendor/fontawesome-free/webfonts/fa-brands-400.woff", "./vendor/fontawesome-free/webfonts/fa-brands-400.woff2", "./vendor/fontawesome-free/webfonts/fa-regular-400.eot", "./vendor/fontawesome-free/webfonts/fa-regular-400.ttf", "./vendor/fontawesome-free/webfonts/fa-regular-400.woff", "./vendor/fontawesome-free/webfonts/fa-regular-400.woff2", "./vendor/fontawesome-free/webfonts/fa-solid-900.eot", "./vendor/fontawesome-free/webfonts/fa-solid-900.ttf", "./vendor/fontawesome-free/webfonts/fa-solid-900.woff", "./vendor/fontawesome-free/webfonts/fa-solid-900.woff2", "./js/sb-admin-2.js", "./js/xmlhttprequests.js", "./js/color-selector.js", "./js/sessionAccordion.js", "./js/pingTable.js", "./js/graphs.js", "./js/network-values.js");
    }

    private void exportResources(ExportPaths exportPaths, Path toDirectory, String ... resourceNames) throws IOException {
        for (String resourceName : resourceNames) {
            String nonRelativePath = this.toNonRelativePath(resourceName);
            this.exportResource(toDirectory, nonRelativePath);
            exportPaths.put(resourceName, this.toRelativePathFromRoot(nonRelativePath));
        }
    }

    private void exportResource(Path toDirectory, String resourceName) throws IOException {
        WebResource resource = ResourceService.getInstance().getResource("Plan", resourceName, () -> this.files.getResourceFromJar("web/" + resourceName).asWebResource());
        Path to = toDirectory.resolve(resourceName);
        if (resourceName.endsWith(".css")) {
            this.export(to, this.theme.replaceThemeColors(resource.asString()));
        } else if ("js/network-values.js".equalsIgnoreCase(resourceName) || "js/sessionAccordion.js".equalsIgnoreCase(resourceName)) {
            String relativePlayerLink = this.toRelativePathFromRoot("player");
            String relativeServerLink = this.toRelativePathFromRoot("server/");
            this.export(to, StringUtils.replaceEach(resource.asString(), new String[]{"../player", "./player", "./server/", "server/"}, new String[]{relativePlayerLink, relativePlayerLink, relativeServerLink, relativeServerLink}));
        } else if (Resource.isTextResource(resourceName)) {
            this.export(to, resource.asString());
        } else {
            this.export(to, resource);
        }
    }

    private String toRelativePathFromRoot(String resourceName) {
        return "../" + this.toNonRelativePath(resourceName);
    }

    private String toNonRelativePath(String resourceName) {
        return StringUtils.remove(StringUtils.remove(resourceName, "../"), "./");
    }
}

