/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.delivery.export.FileExporter;
import com.djrapitops.plan.delivery.webserver.ResponseFactory;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.PlayerFetchQueries;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlayerJSONExporter
extends FileExporter {
    private final DBSystem dbSystem;
    private final ResponseFactory responseFactory;

    @Inject
    public PlayerJSONExporter(DBSystem dbSystem, ResponseFactory responseFactory) {
        this.dbSystem = dbSystem;
        this.responseFactory = responseFactory;
    }

    public void export(Path toDirectory, UUID playerUUID, String playerName) throws IOException {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState == Database.State.CLOSED || dbState == Database.State.CLOSING) {
            return;
        }
        if (!this.dbSystem.getDatabase().query(PlayerFetchQueries.isPlayerRegistered(playerUUID)).booleanValue()) {
            return;
        }
        Path to = toDirectory.resolve("player/" + this.toFileName(playerName) + ".json");
        this.exportJSON(to, playerUUID);
    }

    private void exportJSON(Path to, UUID playerUUID) throws IOException {
        this.export(to, this.responseFactory.rawPlayerPageResponse(playerUUID).getBytes());
    }
}

