/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.delivery.export.ExportPaths;
import com.djrapitops.plan.delivery.export.FileExporter;
import com.djrapitops.plan.delivery.rendering.pages.PageFactory;
import com.djrapitops.plan.delivery.rendering.pages.PlayerPage;
import com.djrapitops.plan.delivery.web.ResourceService;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.exception.NotFoundException;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resource.WebResource;
import com.djrapitops.plan.delivery.webserver.resolver.json.RootJSONResolver;
import com.djrapitops.plan.exceptions.connection.WebException;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.PlayerFetchQueries;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.storage.file.Resource;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;

@Singleton
public class PlayerPageExporter
extends FileExporter {
    private final PlanFiles files;
    private final DBSystem dbSystem;
    private final PageFactory pageFactory;
    private final RootJSONResolver jsonHandler;
    private final Theme theme;

    @Inject
    public PlayerPageExporter(PlanFiles files, DBSystem dbSystem, PageFactory pageFactory, RootJSONResolver jsonHandler, Theme theme) {
        this.files = files;
        this.dbSystem = dbSystem;
        this.pageFactory = pageFactory;
        this.jsonHandler = jsonHandler;
        this.theme = theme;
    }

    public void export(Path toDirectory, UUID playerUUID, String playerName) throws IOException {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState == Database.State.CLOSED || dbState == Database.State.CLOSING) {
            return;
        }
        if (!this.dbSystem.getDatabase().query(PlayerFetchQueries.isPlayerRegistered(playerUUID)).booleanValue()) {
            return;
        }
        ExportPaths exportPaths = new ExportPaths();
        exportPaths.put("../network", this.toRelativePathFromRoot("network"));
        exportPaths.put("../server/", this.toRelativePathFromRoot("server"));
        this.exportRequiredResources(exportPaths, toDirectory);
        Path playerDirectory = toDirectory.resolve("player/" + this.toFileName(playerName));
        this.exportJSON(exportPaths, playerDirectory, playerUUID, playerName);
        this.exportHtml(exportPaths, playerDirectory, playerUUID);
        exportPaths.clear();
    }

    private void exportHtml(ExportPaths exportPaths, Path playerDirectory, UUID playerUUID) throws IOException {
        Path to = playerDirectory.resolve("index.html");
        try {
            PlayerPage page = this.pageFactory.playerPage(playerUUID);
            this.export(to, exportPaths.resolveExportPaths(page.toHtml()));
        }
        catch (IllegalStateException notFound) {
            throw new NotFoundException(notFound.getMessage());
        }
    }

    private void exportJSON(ExportPaths exportPaths, Path toDirectory, UUID playerUUID, String playerName) throws IOException {
        this.exportJSON(exportPaths, toDirectory, "player?player=" + playerUUID, playerName);
    }

    private void exportJSON(ExportPaths exportPaths, Path toDirectory, String resource, String playerName) throws IOException {
        Optional<Response> found = this.getJSONResponse(resource);
        if (!found.isPresent()) {
            throw new NotFoundException(resource + " was not properly exported: no response");
        }
        String jsonResourceName = this.toFileName(this.toJSONResourceName(resource)) + ".json";
        this.export(toDirectory.resolve(jsonResourceName), found.get().getBytes());
        exportPaths.put("../v1/player?player=" + playerName, "./" + jsonResourceName);
    }

    private String toJSONResourceName(String resource) {
        return StringUtils.replaceEach(resource, new String[]{"?", "&", "type=", "player="}, new String[]{"-", "_", "", ""});
    }

    private Optional<Response> getJSONResponse(String resource) {
        try {
            return this.jsonHandler.getResolver().resolve(new Request("GET", "/v1/" + resource, null, Collections.emptyMap()));
        }
        catch (WebException e) {
            throw new IllegalStateException("Unexpected exception thrown: " + e.toString(), e);
        }
    }

    private void exportRequiredResources(ExportPaths exportPaths, Path toDirectory) throws IOException {
        this.exportResources(exportPaths, toDirectory, "../img/Flaticon_circle.png", "../css/sb-admin-2.css", "../css/style.css", "../vendor/jquery/jquery.min.js", "../vendor/bootstrap/js/bootstrap.bundle.min.js", "../vendor/datatables/jquery.dataTables.min.js", "../vendor/datatables/dataTables.bootstrap4.min.js", "../vendor/highcharts/highstock.js", "../vendor/highcharts/map.js", "../vendor/highcharts/world.js", "../vendor/highcharts/drilldown.js", "../vendor/highcharts/highcharts-more.js", "../vendor/highcharts/no-data-to-display.js", "../vendor/fullcalendar/fullcalendar.min.css", "../vendor/momentjs/moment.js", "../vendor/fullcalendar/fullcalendar.min.js", "../vendor/fontawesome-free/css/all.min.css", "../vendor/fontawesome-free/webfonts/fa-brands-400.eot", "../vendor/fontawesome-free/webfonts/fa-brands-400.ttf", "../vendor/fontawesome-free/webfonts/fa-brands-400.woff", "../vendor/fontawesome-free/webfonts/fa-brands-400.woff2", "../vendor/fontawesome-free/webfonts/fa-regular-400.eot", "../vendor/fontawesome-free/webfonts/fa-regular-400.ttf", "../vendor/fontawesome-free/webfonts/fa-regular-400.woff", "../vendor/fontawesome-free/webfonts/fa-regular-400.woff2", "../vendor/fontawesome-free/webfonts/fa-solid-900.eot", "../vendor/fontawesome-free/webfonts/fa-solid-900.ttf", "../vendor/fontawesome-free/webfonts/fa-solid-900.woff", "../vendor/fontawesome-free/webfonts/fa-solid-900.woff2", "../js/sb-admin-2.js", "../js/xmlhttprequests.js", "../js/color-selector.js", "../js/sessionAccordion.js", "../js/graphs.js", "../js/player-values.js");
    }

    private void exportResources(ExportPaths exportPaths, Path toDirectory, String ... resourceNames) throws IOException {
        for (String resourceName : resourceNames) {
            String nonRelativePath = this.toNonRelativePath(resourceName);
            this.exportResource(toDirectory, nonRelativePath);
            exportPaths.put(resourceName, this.toRelativePathFromRoot(nonRelativePath));
        }
    }

    private void exportResource(Path toDirectory, String resourceName) throws IOException {
        WebResource resource = ResourceService.getInstance().getResource("Plan", resourceName, () -> this.files.getResourceFromJar("web/" + resourceName).asWebResource());
        Path to = toDirectory.resolve(resourceName);
        if (resourceName.endsWith(".css")) {
            this.export(to, this.theme.replaceThemeColors(resource.asString()));
        } else if (Resource.isTextResource(resourceName)) {
            this.export(to, resource.asString());
        } else {
            this.export(to, resource);
        }
    }

    private String toRelativePathFromRoot(String resourceName) {
        return "../../" + this.toNonRelativePath(resourceName);
    }

    private String toNonRelativePath(String resourceName) {
        return StringUtils.remove(StringUtils.remove(resourceName, "../"), "./");
    }
}

