/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.delivery.export.ExportPaths;
import com.djrapitops.plan.delivery.export.FileExporter;
import com.djrapitops.plan.delivery.rendering.pages.PageFactory;
import com.djrapitops.plan.delivery.rendering.pages.PlayersPage;
import com.djrapitops.plan.delivery.web.ResourceService;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.exception.NotFoundException;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resource.WebResource;
import com.djrapitops.plan.delivery.webserver.resolver.json.RootJSONResolver;
import com.djrapitops.plan.exceptions.connection.WebException;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.storage.file.Resource;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;

@Singleton
public class PlayersPageExporter
extends FileExporter {
    private final PlanFiles files;
    private final DBSystem dbSystem;
    private final PageFactory pageFactory;
    private final RootJSONResolver jsonHandler;
    private final Theme theme;
    private final ServerInfo serverInfo;
    private final ExportPaths exportPaths;

    @Inject
    public PlayersPageExporter(PlanFiles files, DBSystem dbSystem, PageFactory pageFactory, RootJSONResolver jsonHandler, Theme theme, ServerInfo serverInfo) {
        this.files = files;
        this.dbSystem = dbSystem;
        this.pageFactory = pageFactory;
        this.jsonHandler = jsonHandler;
        this.theme = theme;
        this.serverInfo = serverInfo;
        this.exportPaths = new ExportPaths();
    }

    public void export(Path toDirectory) throws IOException {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState == Database.State.CLOSED || dbState == Database.State.CLOSING) {
            return;
        }
        this.exportPaths.put("href=\"/\"", "href=\"" + this.toRelativePathFromRoot(this.serverInfo.getServer().isProxy() ? "network" : "server") + '\"');
        this.exportRequiredResources(toDirectory);
        this.exportJSON(toDirectory);
        this.exportHtml(toDirectory);
        this.exportPaths.clear();
    }

    private void exportHtml(Path toDirectory) throws IOException {
        Path to = toDirectory.resolve("players").resolve("index.html");
        PlayersPage page = this.pageFactory.playersPage();
        this.export(to, this.exportPaths.resolveExportPaths(page.toHtml()));
    }

    private void exportJSON(Path toDirectory) throws IOException {
        Optional<Response> found = this.getJSONResponse("players");
        if (!found.isPresent()) {
            throw new NotFoundException("players page was not properly exported: not found");
        }
        String jsonResourceName = this.toFileName(this.toJSONResourceName("players")) + ".json";
        this.export(toDirectory.resolve("data").resolve(jsonResourceName), StringUtils.replace(found.get().getAsString(), "../player", this.toRelativePathFromRoot("player")));
        this.exportPaths.put("./v1/players", this.toRelativePathFromRoot("data/" + jsonResourceName));
    }

    private String toJSONResourceName(String resource) {
        return StringUtils.replaceEach(resource, new String[]{"?", "&", "type=", "server="}, new String[]{"-", "_", "", ""});
    }

    private Optional<Response> getJSONResponse(String resource) {
        try {
            return this.jsonHandler.getResolver().resolve(new Request("GET", "/v1/" + resource, null, Collections.emptyMap()));
        }
        catch (WebException e) {
            throw new IllegalStateException("Unexpected exception thrown: " + e.toString(), e);
        }
    }

    private void exportRequiredResources(Path toDirectory) throws IOException {
        this.exportResources(toDirectory, "img/Flaticon_circle.png", "css/sb-admin-2.css", "css/style.css", "vendor/jquery/jquery.min.js", "vendor/bootstrap/js/bootstrap.bundle.min.js", "vendor/datatables/jquery.dataTables.min.js", "vendor/datatables/dataTables.bootstrap4.min.js", "vendor/fontawesome-free/css/all.min.css", "vendor/fontawesome-free/webfonts/fa-brands-400.eot", "vendor/fontawesome-free/webfonts/fa-brands-400.ttf", "vendor/fontawesome-free/webfonts/fa-brands-400.woff", "vendor/fontawesome-free/webfonts/fa-brands-400.woff2", "vendor/fontawesome-free/webfonts/fa-regular-400.eot", "vendor/fontawesome-free/webfonts/fa-regular-400.ttf", "vendor/fontawesome-free/webfonts/fa-regular-400.woff", "vendor/fontawesome-free/webfonts/fa-regular-400.woff2", "vendor/fontawesome-free/webfonts/fa-solid-900.eot", "vendor/fontawesome-free/webfonts/fa-solid-900.ttf", "vendor/fontawesome-free/webfonts/fa-solid-900.woff", "vendor/fontawesome-free/webfonts/fa-solid-900.woff2", "js/sb-admin-2.js", "js/xmlhttprequests.js", "js/color-selector.js");
    }

    private void exportResources(Path toDirectory, String ... resourceNames) throws IOException {
        for (String resourceName : resourceNames) {
            this.exportResource(toDirectory, resourceName);
        }
    }

    private void exportResource(Path toDirectory, String resourceName) throws IOException {
        WebResource resource = ResourceService.getInstance().getResource("Plan", resourceName, () -> this.files.getResourceFromJar("web/" + resourceName).asWebResource());
        Path to = toDirectory.resolve(resourceName);
        if (resourceName.endsWith(".css")) {
            this.export(to, this.theme.replaceThemeColors(resource.asString()));
        } else if (Resource.isTextResource(resourceName)) {
            this.export(to, resource.asString());
        } else {
            this.export(to, resource);
        }
        this.exportPaths.put(resourceName, this.toRelativePathFromRoot(resourceName));
    }

    private String toRelativePathFromRoot(String resourceName) {
        return "../" + this.toNonRelativePath(resourceName);
    }

    private String toNonRelativePath(String resourceName) {
        return StringUtils.remove(resourceName, "../");
    }
}

