/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.export;

import com.djrapitops.plan.delivery.export.ExportPaths;
import com.djrapitops.plan.delivery.export.FileExporter;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.delivery.rendering.pages.PageFactory;
import com.djrapitops.plan.delivery.web.ResourceService;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.exception.NotFoundException;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resource.WebResource;
import com.djrapitops.plan.delivery.webserver.resolver.json.RootJSONResolver;
import com.djrapitops.plan.exceptions.connection.WebException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.storage.file.Resource;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;

@Singleton
public class ServerPageExporter
extends FileExporter {
    private final PlanFiles files;
    private final PageFactory pageFactory;
    private final DBSystem dbSystem;
    private final RootJSONResolver jsonHandler;
    private final Theme theme;
    private final ServerInfo serverInfo;
    private final ExportPaths exportPaths;

    @Inject
    public ServerPageExporter(PlanFiles files, PageFactory pageFactory, DBSystem dbSystem, RootJSONResolver jsonHandler, Theme theme, ServerInfo serverInfo) {
        this.files = files;
        this.pageFactory = pageFactory;
        this.dbSystem = dbSystem;
        this.jsonHandler = jsonHandler;
        this.theme = theme;
        this.serverInfo = serverInfo;
        this.exportPaths = new ExportPaths();
    }

    public void export(Path toDirectory, Server server) throws IOException {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState == Database.State.CLOSED || dbState == Database.State.CLOSING) {
            return;
        }
        this.exportPaths.put("../network", this.toRelativePathFromRoot("network"));
        this.exportRequiredResources(toDirectory);
        this.exportJSON(toDirectory, server);
        this.exportHtml(toDirectory, server);
        this.exportPaths.clear();
    }

    private void exportHtml(Path toDirectory, Server server) throws IOException {
        UUID serverUUID = server.getUuid();
        Path to = toDirectory.resolve(this.serverInfo.getServer().isProxy() ? "server/" + this.toFileName(server.getName()) : "server").resolve("index.html");
        Page page = this.pageFactory.serverPage(serverUUID);
        this.export(to, this.exportPaths.resolveExportPaths(page.toHtml()));
    }

    public void exportJSON(Path toDirectory, Server server) throws IOException {
        String serverUUID = server.getUuid().toString();
        this.exportJSON(toDirectory, "serverOverview?server=" + serverUUID, "onlineOverview?server=" + serverUUID, "sessionsOverview?server=" + serverUUID, "playerVersus?server=" + serverUUID, "playerbaseOverview?server=" + serverUUID, "performanceOverview?server=" + serverUUID, "graph?type=performance&server=" + serverUUID, "graph?type=aggregatedPing&server=" + serverUUID, "graph?type=worldPie&server=" + serverUUID, "graph?type=activity&server=" + serverUUID, "graph?type=geolocation&server=" + serverUUID, "graph?type=uniqueAndNew&server=" + serverUUID, "graph?type=serverCalendar&server=" + serverUUID, "graph?type=punchCard&server=" + serverUUID, "players?server=" + serverUUID, "kills?server=" + serverUUID, "pingTable?server=" + serverUUID, "sessions?server=" + serverUUID);
    }

    private void exportJSON(Path toDirectory, String ... resources) throws IOException {
        for (String resource : resources) {
            this.exportJSON(toDirectory, resource);
        }
    }

    private void exportJSON(Path toDirectory, String resource) throws IOException {
        Optional<Response> found = this.getJSONResponse(resource);
        if (!found.isPresent()) {
            throw new NotFoundException(resource + " was not properly exported: not found");
        }
        String jsonResourceName = this.toFileName(this.toJSONResourceName(resource)) + ".json";
        this.export(toDirectory.resolve("data").resolve(jsonResourceName), StringUtils.replace(found.get().getAsString(), "../player", this.toRelativePathFromRoot("player")));
        this.exportPaths.put("../v1/" + resource, this.toRelativePathFromRoot("data/" + jsonResourceName));
    }

    private String toJSONResourceName(String resource) {
        return StringUtils.replaceEach(resource, new String[]{"?", "&", "type=", "server="}, new String[]{"-", "_", "", ""});
    }

    private Optional<Response> getJSONResponse(String resource) {
        try {
            return this.jsonHandler.getResolver().resolve(new Request("GET", "/v1/" + resource, null, Collections.emptyMap()));
        }
        catch (WebException e) {
            throw new IllegalStateException("Unexpected exception thrown: " + e.toString(), e);
        }
    }

    private void exportRequiredResources(Path toDirectory) throws IOException {
        this.exportResources(toDirectory, "../img/Flaticon_circle.png", "../css/sb-admin-2.css", "../css/style.css", "../vendor/jquery/jquery.min.js", "../vendor/bootstrap/js/bootstrap.bundle.min.js", "../vendor/datatables/jquery.dataTables.min.js", "../vendor/datatables/dataTables.bootstrap4.min.js", "../vendor/highcharts/highstock.js", "../vendor/highcharts/map.js", "../vendor/highcharts/world.js", "../vendor/highcharts/drilldown.js", "../vendor/highcharts/highcharts-more.js", "../vendor/highcharts/no-data-to-display.js", "../vendor/fullcalendar/fullcalendar.min.css", "../vendor/momentjs/moment.js", "../vendor/fullcalendar/fullcalendar.min.js", "../vendor/fontawesome-free/css/all.min.css", "../vendor/fontawesome-free/webfonts/fa-brands-400.eot", "../vendor/fontawesome-free/webfonts/fa-brands-400.ttf", "../vendor/fontawesome-free/webfonts/fa-brands-400.woff", "../vendor/fontawesome-free/webfonts/fa-brands-400.woff2", "../vendor/fontawesome-free/webfonts/fa-regular-400.eot", "../vendor/fontawesome-free/webfonts/fa-regular-400.ttf", "../vendor/fontawesome-free/webfonts/fa-regular-400.woff", "../vendor/fontawesome-free/webfonts/fa-regular-400.woff2", "../vendor/fontawesome-free/webfonts/fa-solid-900.eot", "../vendor/fontawesome-free/webfonts/fa-solid-900.ttf", "../vendor/fontawesome-free/webfonts/fa-solid-900.woff", "../vendor/fontawesome-free/webfonts/fa-solid-900.woff2", "../js/sb-admin-2.js", "../js/xmlhttprequests.js", "../js/color-selector.js", "../js/sessionAccordion.js", "../js/pingTable.js", "../js/graphs.js", "../js/server-values.js");
    }

    private void exportResources(Path toDirectory, String ... resourceNames) throws IOException {
        for (String resourceName : resourceNames) {
            String nonRelativePath = this.toNonRelativePath(resourceName);
            this.exportResource(toDirectory, nonRelativePath);
            this.exportPaths.put(resourceName, this.toRelativePathFromRoot(nonRelativePath));
        }
    }

    private void exportResource(Path toDirectory, String resourceName) throws IOException {
        WebResource resource = ResourceService.getInstance().getResource("Plan", resourceName, () -> this.files.getResourceFromJar("web/" + resourceName).asWebResource());
        Path to = toDirectory.resolve(resourceName);
        if (resourceName.endsWith(".css")) {
            this.export(to, this.theme.replaceThemeColors(resource.asString()));
        } else if (Resource.isTextResource(resourceName)) {
            this.export(to, resource.asString());
        } else {
            this.export(to, resource);
        }
    }

    private String toRelativePathFromRoot(String resourceName) {
        return (this.serverInfo.getServer().isProxy() ? "../../" : "../") + this.toNonRelativePath(resourceName);
    }

    private String toNonRelativePath(String resourceName) {
        return StringUtils.remove(StringUtils.remove(resourceName, "../"), "./");
    }
}

