/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.formatting;

import com.djrapitops.plan.delivery.domain.DateHolder;
import com.djrapitops.plan.delivery.formatting.DecimalFormatter;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.PercentageFormatter;
import com.djrapitops.plan.delivery.formatting.time.ClockFormatter;
import com.djrapitops.plan.delivery.formatting.time.DateHolderFormatter;
import com.djrapitops.plan.delivery.formatting.time.DayFormatter;
import com.djrapitops.plan.delivery.formatting.time.ISO8601NoClockFormatter;
import com.djrapitops.plan.delivery.formatting.time.ISO8601NoClockTZIndependentFormatter;
import com.djrapitops.plan.delivery.formatting.time.SecondFormatter;
import com.djrapitops.plan.delivery.formatting.time.TimeAmountFormatter;
import com.djrapitops.plan.delivery.formatting.time.YearFormatter;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.locale.Locale;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class Formatters {
    private final DateHolderFormatter yearFormatter;
    private final DateHolderFormatter dayFormatter;
    private final DateHolderFormatter secondFormatter;
    private final DateHolderFormatter clockFormatter;
    private final DateHolderFormatter iso8601NoClockFormatter;
    private final YearFormatter yearLongFormatter;
    private final DayFormatter dayLongFormatter;
    private final SecondFormatter secondLongFormatter;
    private final ClockFormatter clockLongFormatter;
    private final ISO8601NoClockFormatter iso8601NoClockLongFormatter;
    private final ISO8601NoClockTZIndependentFormatter iso8601NoClockTZIndependentFormatter;
    private final TimeAmountFormatter timeAmountFormatter;
    private final DecimalFormatter decimalFormatter;
    private final PercentageFormatter percentageFormatter;

    @Inject
    public Formatters(PlanConfig config, Locale locale) {
        this.yearLongFormatter = new YearFormatter(config, locale);
        this.dayLongFormatter = new DayFormatter(config, locale);
        this.clockLongFormatter = new ClockFormatter(config, locale);
        this.secondLongFormatter = new SecondFormatter(config, locale);
        this.iso8601NoClockLongFormatter = new ISO8601NoClockFormatter(config, locale);
        this.iso8601NoClockTZIndependentFormatter = new ISO8601NoClockTZIndependentFormatter();
        this.yearFormatter = new DateHolderFormatter(this.yearLongFormatter);
        this.dayFormatter = new DateHolderFormatter(this.dayLongFormatter);
        this.secondFormatter = new DateHolderFormatter(this.secondLongFormatter);
        this.clockFormatter = new DateHolderFormatter(this.clockLongFormatter);
        this.iso8601NoClockFormatter = new DateHolderFormatter(this.iso8601NoClockLongFormatter);
        this.timeAmountFormatter = new TimeAmountFormatter(config);
        this.decimalFormatter = new DecimalFormatter(config);
        this.percentageFormatter = new PercentageFormatter(this.decimalFormatter);
    }

    public Formatter<DateHolder> year() {
        return this.yearFormatter;
    }

    public Formatter<Long> yearLong() {
        return this.yearLongFormatter;
    }

    public Formatter<DateHolder> day() {
        return this.dayFormatter;
    }

    public Formatter<Long> dayLong() {
        return this.dayLongFormatter;
    }

    public Formatter<DateHolder> second() {
        return this.secondFormatter;
    }

    public Formatter<Long> secondLong() {
        return this.secondLongFormatter;
    }

    public Formatter<DateHolder> clock() {
        return this.clockFormatter;
    }

    public Formatter<Long> clockLong() {
        return this.clockLongFormatter;
    }

    public Formatter<DateHolder> iso8601NoClock() {
        return this.iso8601NoClockFormatter;
    }

    public Formatter<Long> iso8601NoClockLong() {
        return this.iso8601NoClockLongFormatter;
    }

    public Formatter<Long> iso8601NoClockTZIndependentLong() {
        return this.iso8601NoClockTZIndependentFormatter;
    }

    public Formatter<Long> timeAmount() {
        return this.timeAmountFormatter;
    }

    public Formatter<Double> percentage() {
        return this.percentageFormatter;
    }

    public Formatter<Double> decimals() {
        return this.decimalFormatter;
    }
}

