/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.formatting.time;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.FormatSettings;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.GenericLang;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public abstract class DateFormatter
implements Formatter<Long> {
    protected final PlanConfig config;
    protected final Locale locale;

    public DateFormatter(PlanConfig config, Locale locale) {
        this.config = config;
        this.locale = locale;
    }

    @Override
    public abstract String apply(Long var1);

    protected String format(long epochMs, String format) {
        String localeSetting = this.config.get(PluginSettings.LOCALE);
        java.util.Locale usedLocale = "default".equalsIgnoreCase(localeSetting) ? java.util.Locale.ENGLISH : java.util.Locale.forLanguageTag(localeSetting);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, usedLocale);
        TimeZone timeZone = this.config.getTimeZone();
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(epochMs);
    }

    protected String replaceRecentDays(long epochMs, String format) {
        return this.replaceRecentDays(epochMs, format, this.config.get(FormatSettings.DATE_RECENT_DAYS_PATTERN));
    }

    protected String replaceRecentDays(long epochMs, String format, String pattern) {
        TimeZone timeZone;
        int offset;
        long fromStartOfDay;
        long now = System.currentTimeMillis();
        if (epochMs > now - (fromStartOfDay = (now + (long)(offset = (timeZone = this.config.getTimeZone()).getOffset(epochMs))) % TimeUnit.DAYS.toMillis(1L))) {
            format = format.replace(pattern, this.locale.getString(GenericLang.TODAY));
        } else if (epochMs > now - TimeUnit.DAYS.toMillis(1L) - fromStartOfDay) {
            format = format.replace(pattern, this.locale.getString(GenericLang.YESTERDAY));
        } else if (epochMs > now - TimeUnit.DAYS.toMillis(5L)) {
            format = format.replace(pattern, "EEEE");
        }
        return format;
    }
}

