/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.formatting.time;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.FormatSettings;
import plan.org.apache.commons.lang3.StringUtils;

public class TimeAmountFormatter
implements Formatter<Long> {
    private static final String ZERO_PH = "%zero%";
    private static final String SECONDS_PH = "%seconds%";
    private static final String MINUTES_PH = "%minutes%";
    private static final String HOURS_PH = "%hours%";
    private static final String DAYS_PH = "%days%";
    private static final String MONTHS_PH = "%months%";
    private static final String YEARS_PH = "%years%";
    private final PlanConfig config;

    public TimeAmountFormatter(PlanConfig config) {
        this.config = config;
    }

    @Override
    public String apply(Long ms) {
        if (ms == null || ms < 0L) {
            return "-";
        }
        StringBuilder builder = new StringBuilder();
        long x = ms / 1000L;
        long seconds = x % 60L;
        long minutes = (x /= 60L) % 60L;
        long hours = (x /= 60L) % 24L;
        long days = (x /= 24L) % 365L;
        long months = (days - days % 30L) / 30L;
        long years = x /= 365L;
        this.appendYears(builder, years);
        this.appendMonths(builder, months);
        this.appendDays(builder, days -= months * 30L);
        String hourFormat = this.config.get(FormatSettings.HOURS);
        String minuteFormat = this.config.get(FormatSettings.MINUTES);
        String secondFormat = this.config.get(FormatSettings.SECONDS);
        this.appendHours(builder, hours, hourFormat);
        this.appendMinutes(builder, minutes, hours, hourFormat, minuteFormat);
        this.appendSeconds(builder, seconds, minutes, hours, hourFormat, minuteFormat, secondFormat);
        String formattedTime = StringUtils.remove(builder.toString(), ZERO_PH);
        if (formattedTime.isEmpty()) {
            return this.config.get(FormatSettings.ZERO_SECONDS);
        }
        return formattedTime;
    }

    private void appendHours(StringBuilder builder, long hours, String fHours) {
        if (hours != 0L) {
            String h = fHours.replace(HOURS_PH, String.valueOf(hours));
            if (h.contains(ZERO_PH) && String.valueOf(hours).length() == 1) {
                builder.append('0');
            }
            builder.append(h);
        }
    }

    private void appendMinutes(StringBuilder builder, long minutes, long hours, String fHours, String fMinutes) {
        if (minutes != 0L) {
            String m = fMinutes.replace(MINUTES_PH, String.valueOf(minutes));
            if (hours == 0L && m.contains(HOURS_PH)) {
                builder.append(fHours.replace(ZERO_PH, "0").replace(HOURS_PH, "0"));
                m = m.replace(HOURS_PH, "");
            }
            if ((m = m.replace(HOURS_PH, "")).contains(ZERO_PH) && String.valueOf(minutes).length() == 1) {
                builder.append('0');
            }
            builder.append(m);
        }
    }

    private void appendSeconds(StringBuilder builder, long seconds, long minutes, long hours, String fHours, String fMinutes, String fSeconds) {
        if (seconds != 0L || fSeconds.contains(ZERO_PH)) {
            String s = fSeconds.replace(SECONDS_PH, String.valueOf(seconds));
            if (minutes == 0L && s.contains(MINUTES_PH)) {
                if (hours == 0L && fMinutes.contains(HOURS_PH)) {
                    builder.append(fHours.replace(ZERO_PH, "0").replace(HOURS_PH, "0"));
                }
                builder.append(fMinutes.replace(HOURS_PH, "").replace(ZERO_PH, "0").replace(MINUTES_PH, "0"));
            }
            if ((s = s.replace(MINUTES_PH, "")).contains(ZERO_PH) && String.valueOf(seconds).length() == 1) {
                builder.append('0');
            }
            builder.append(s);
        }
    }

    private void appendDays(StringBuilder builder, long days) {
        String singular = this.config.get(FormatSettings.DAY);
        String plural = this.config.get(FormatSettings.DAYS);
        this.appendValue(builder, days, singular, plural, DAYS_PH);
    }

    private void appendMonths(StringBuilder builder, long months) {
        String singular = this.config.get(FormatSettings.MONTH);
        String plural = this.config.get(FormatSettings.MONTHS);
        this.appendValue(builder, months, singular, plural, MONTHS_PH);
    }

    private void appendYears(StringBuilder builder, long years) {
        String singular = this.config.get(FormatSettings.YEAR);
        String plural = this.config.get(FormatSettings.YEARS);
        this.appendValue(builder, years, singular, plural, YEARS_PH);
    }

    private void appendValue(StringBuilder builder, long amount, String singular, String plural, String replace) {
        if (amount != 0L) {
            if (amount == 1L) {
                builder.append(singular);
            } else {
                builder.append(plural.replace(replace, String.valueOf(amount)));
            }
        }
    }
}

