/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.html;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import plan.org.apache.commons.lang3.StringUtils;
import plan.org.apache.commons.text.StringSubstitutor;
import plan.org.apache.commons.text.TextStringBuilder;

public enum Html {
    COLOR_0("<span class=\"black\">"),
    COLOR_1("<span class=\"darkblue\">"),
    COLOR_2("<span class=\"darkgreen\">"),
    COLOR_3("<span class=\"darkaqua\">"),
    COLOR_4("<span class=\"darkred\">"),
    COLOR_5("<span class=\"darkpurple\">"),
    COLOR_6("<span class=\"gold\">"),
    COLOR_7("<span class=\"gray\">"),
    COLOR_8("<span class=\"darkgray\">"),
    COLOR_9("<span class=\"blue\">"),
    COLOR_A("<span class=\"green\">"),
    COLOR_B("<span class=\"aqua\">"),
    COLOR_C("<span class=\"red\">"),
    COLOR_D("<span class=\"pink\">"),
    COLOR_E("<span class=\"yellow\">"),
    COLOR_F("<span class=\"white\">"),
    SPAN("${0}</span>"),
    LINK("<a class=\"link\" href=\"${0}\">${1}</a>"),
    LINK_EXTERNAL("<a class=\"link\" rel=\"noopener noreferrer\" target=\"_blank\" href=\"${0}\">${1}</a>"),
    BACK_BUTTON_NETWORK("<a class=\"btn bg-plan btn-icon-split\" href=\"../network\"><span class=\"icon text-white-50\"><i class=\"fas fa-fw fa-arrow-left\"></i><i class=\"fas fa-fw fa-cloud\"></i></span><span class=\"text\">Network page</span></a>"),
    BACK_BUTTON_SERVER("<a class=\"btn bg-plan btn-icon-split\" href=\"../server/\"><span class=\"icon text-white-50\"><i class=\"fas fa-fw fa-arrow-left\"></i><i class=\"fas fa-fw fa-server\"></i></span><span class=\"text\">Server page</span></a>");

    private final String html;

    private Html(String html) {
        this.html = html;
    }

    public static String swapColorCodesToSpan(String string) {
        Html[] replacer = new Html[]{COLOR_0, COLOR_1, COLOR_2, COLOR_3, COLOR_4, COLOR_5, COLOR_6, COLOR_7, COLOR_8, COLOR_9, COLOR_A, COLOR_B, COLOR_C, COLOR_D, COLOR_E, COLOR_F};
        HashMap<Character, String> colorMap = new HashMap<Character, String>();
        String splitWith = string.contains("&sect;") ? "&sect;" : "\u00a7";
        for (Html html : replacer) {
            colorMap.put(Character.valueOf(Character.toLowerCase(html.name().charAt(6))), html.create());
            colorMap.put(Character.valueOf('k'), "");
            colorMap.put(Character.valueOf('l'), "");
            colorMap.put(Character.valueOf('m'), "");
            colorMap.put(Character.valueOf('n'), "");
            colorMap.put(Character.valueOf('o'), "");
        }
        StringBuilder result = new StringBuilder(string.length());
        String[] split = string.split(splitWith);
        boolean skipFirst = !string.startsWith(splitWith);
        int placedSpans = 0;
        for (String part : split) {
            if (part.isEmpty()) continue;
            if (skipFirst) {
                result.append(part);
                skipFirst = false;
                continue;
            }
            char colorChar = part.charAt(0);
            if (colorChar == 'r') {
                Html.appendEndTags(result, placedSpans);
                placedSpans = 0;
                result.append(part.substring(1));
                continue;
            }
            String replacement = (String)colorMap.get(Character.valueOf(colorChar));
            if (replacement != null) {
                result.append(replacement).append(part.substring(1));
                if (replacement.isEmpty()) continue;
                ++placedSpans;
                continue;
            }
            result.append(part);
        }
        Html.appendEndTags(result, placedSpans);
        return result.toString();
    }

    public static String separateWithDots(String ... elements) {
        TextStringBuilder builder = new TextStringBuilder();
        builder.appendWithSeparators(elements, " &#x2022; ");
        return builder.toString();
    }

    public String create() {
        return this.html;
    }

    private static void appendEndTags(StringBuilder result, int placedSpans) {
        for (int i = 0; i < placedSpans; ++i) {
            result.append("</span>");
        }
    }

    public String create(Serializable ... replacements) {
        HashMap<String, Serializable> replaceMap = new HashMap<String, Serializable>();
        for (int i = 0; i < replacements.length; ++i) {
            replaceMap.put(String.valueOf(i), replacements[i]);
        }
        StringSubstitutor sub = new StringSubstitutor(replaceMap);
        sub.setEnableSubstitutionInVariables(false);
        return sub.replace(this.html);
    }

    public static String encodeToURL(String string) {
        try {
            return StringUtils.replace(URLEncoder.encode(string, "UTF-8"), "+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }
}

