/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.html.icon;

import com.djrapitops.plan.delivery.rendering.html.icon.Color;
import com.djrapitops.plan.delivery.rendering.html.icon.Family;
import com.djrapitops.plugin.utilities.Verify;

public class Icon {
    private Family type;
    private String name;
    private Color color;

    private Icon() {
        this.type = Family.SOLID;
        this.color = Color.NONE;
    }

    public static Icon fromExtensionIcon(com.djrapitops.plan.extension.icon.Icon icon) {
        if (icon == null) {
            return Icon.called("question").build();
        }
        return new Icon(Family.getByName(icon.getFamily().name()).orElse(Family.SOLID), icon.getName(), Color.getByName(icon.getColor().name()).orElse(Color.NONE));
    }

    public Icon(Family type, String name, Color color) {
        this.type = type;
        this.name = name;
        this.color = color;
    }

    public Family getFamily() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public static Builder called(String name) {
        return new Builder().called(name);
    }

    public static Builder of(Family type) {
        return new Builder().of(type);
    }

    public static Builder of(Color color) {
        return new Builder().of(color);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String toHtml() {
        return this.type.appendAround(this.color.getHtmlClass(), this.name);
    }

    public String toString() {
        return this.toHtml();
    }

    public static class Builder {
        private final Icon icon = new Icon();

        Builder() {
        }

        public Builder called(String name) {
            this.icon.name = name;
            return this;
        }

        public Builder of(Color color) {
            this.icon.color = color;
            return this;
        }

        public Builder of(Family type) {
            this.icon.type = type;
            return this;
        }

        public Icon build() {
            Verify.nullCheck(this.icon.name, () -> new IllegalStateException("'name' was not defined yet!"));
            return this.icon;
        }

        public String toString() {
            return this.build().toHtml();
        }
    }
}

