/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.html.structure;

import com.djrapitops.plan.delivery.rendering.html.icon.Icon;
import plan.org.apache.commons.lang3.StringUtils;

public class NavLink {
    private final Icon icon;
    private String tabID;
    private final String tabName;
    private final boolean collapsed;

    private NavLink(Icon icon, String tabID, String tabName, boolean collapsed) {
        this.icon = icon;
        this.tabID = tabID;
        this.tabName = tabName;
        this.collapsed = collapsed;
    }

    public static NavLink main(Icon icon, String tabName) {
        return new NavLink(icon, null, tabName, false);
    }

    public static NavLink main(Icon icon, String tabID, String tabName) {
        return new NavLink(icon, tabID, tabName, false);
    }

    public static NavLink collapsed(Icon icon, String tabName) {
        return new NavLink(icon, null, tabName, true);
    }

    public static NavLink collapsed(Icon icon, String tabID, String tabName) {
        return new NavLink(icon, tabID, tabName, true);
    }

    public static String format(String id) {
        return StringUtils.replaceChars(StringUtils.lowerCase(id), ' ', '-');
    }

    public String toHtml() {
        String usedId = this.getUsedTabId();
        if (this.collapsed) {
            return "<a class=\"collapse-item nav-button\" href=\"#tab-" + usedId + "\">" + this.icon.toHtml() + ' ' + this.tabName + "</a>";
        }
        return "<li class=\"nav-item nav-button\"><a class=\"nav-link\" href=\"#tab-" + usedId + "\">" + this.icon.toHtml() + "<span>" + this.tabName + "</span></a></li>";
    }

    private String getUsedTabId() {
        return NavLink.format(this.tabID != null ? this.tabID : this.tabName);
    }
}

