/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.domain.mutators.PlayerKillMutator;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.PlayersTableJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.graphs.Graphs;
import com.djrapitops.plan.extension.implementation.storage.queries.ExtensionServerPlayerDataTableQuery;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DisplaySettings;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.analysis.PlayerCountQueries;
import com.djrapitops.plan.storage.database.queries.objects.KillQueries;
import com.djrapitops.plan.storage.database.queries.objects.NetworkTablePlayersQuery;
import com.djrapitops.plan.storage.database.queries.objects.PingQueries;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.queries.objects.ServerTablePlayersQuery;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import com.djrapitops.plan.utilities.comparators.SessionStartComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class JSONFactory {
    private final PlanConfig config;
    private final Locale locale;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final Graphs graphs;
    private final Formatters formatters;

    @Inject
    public JSONFactory(PlanConfig config, Locale locale, DBSystem dbSystem, ServerInfo serverInfo, Graphs graphs, Formatters formatters) {
        this.config = config;
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.graphs = graphs;
        this.formatters = formatters;
    }

    public String serverPlayersTableJSON(UUID serverUUID) {
        Integer xMostRecentPlayers = this.config.get(DisplaySettings.PLAYERS_PER_SERVER_PAGE);
        Long playtimeThreshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        boolean openPlayerLinksInNewTab = this.config.isTrue(DisplaySettings.OPEN_PLAYER_LINKS_IN_NEW_TAB);
        Database database = this.dbSystem.getDatabase();
        return new PlayersTableJSONCreator(database.query(new ServerTablePlayersQuery(serverUUID, System.currentTimeMillis(), playtimeThreshold, xMostRecentPlayers)), database.query(new ExtensionServerPlayerDataTableQuery(serverUUID, xMostRecentPlayers)), openPlayerLinksInNewTab, this.formatters, this.locale).toJSONString();
    }

    public String networkPlayersTableJSON() {
        Integer xMostRecentPlayers = this.config.get(DisplaySettings.PLAYERS_PER_PLAYERS_PAGE);
        Long playtimeThreshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        boolean openPlayerLinksInNewTab = this.config.isTrue(DisplaySettings.OPEN_PLAYER_LINKS_IN_NEW_TAB);
        Database database = this.dbSystem.getDatabase();
        return new PlayersTableJSONCreator(database.query(new NetworkTablePlayersQuery(System.currentTimeMillis(), playtimeThreshold, xMostRecentPlayers)), Collections.emptyMap(), openPlayerLinksInNewTab, this.formatters, this.locale).toJSONString();
    }

    public List<Map<String, Object>> serverSessionsAsJSONMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        Integer perPageLimit = this.config.get(DisplaySettings.SESSIONS_PER_PAGE);
        List<Session> sessions = db.query(SessionQueries.fetchLatestSessionsOfServer(serverUUID, perPageLimit));
        if (serverUUID.equals(this.serverInfo.getServerUUID())) {
            int size;
            sessions.addAll(SessionCache.getActiveSessions().values());
            sessions.sort(new SessionStartComparator());
            while ((size = sessions.size()) > perPageLimit) {
                sessions.remove(size - 1);
            }
        }
        return new SessionsMutator(sessions).toPlayerNameJSONMaps(this.graphs, this.config.getWorldAliasSettings(), this.formatters);
    }

    public List<Map<String, Object>> networkSessionsAsJSONMap() {
        Database db = this.dbSystem.getDatabase();
        Integer perPageLimit = this.config.get(DisplaySettings.SESSIONS_PER_PAGE);
        List<Session> sessions = db.query(SessionQueries.fetchLatestSessions(perPageLimit));
        if (this.serverInfo.getServer().isProxy()) {
            int size;
            sessions.addAll(SessionCache.getActiveSessions().values());
            sessions.sort(new SessionStartComparator());
            while ((size = sessions.size()) > perPageLimit) {
                sessions.remove(size - 1);
            }
        }
        List<Map<String, Object>> sessionMaps = new SessionsMutator(sessions).toPlayerNameJSONMaps(this.graphs, this.config.getWorldAliasSettings(), this.formatters);
        sessionMaps.forEach(map -> map.put("network_server", map.get("server_name")));
        return sessionMaps;
    }

    public List<Map<String, Object>> serverPlayerKillsAsJSONMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        List<PlayerKill> kills = db.query(KillQueries.fetchPlayerKillsOnServer(serverUUID, 100));
        return new PlayerKillMutator(kills).toJSONAsMap(this.formatters);
    }

    public List<Map<String, Object>> serversAsJSONMaps() {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long weekAgo = now - TimeUnit.DAYS.toMillis(7L);
        Formatter<Long> year = this.formatters.yearLong();
        Formatter<Double> decimals = this.formatters.decimals();
        Formatter<Long> timeAmount = this.formatters.timeAmount();
        Map<UUID, Server> serverInformation = db.query(ServerQueries.fetchPlanServerInformation());
        UUID proxyUUID = serverInformation.values().stream().filter(Server::isProxy).findFirst().map(Server::getUuid).orElse(null);
        Map<UUID, List<TPS>> tpsData = db.query(TPSQueries.fetchTPSDataOfAllServersBut(weekAgo, now, proxyUUID));
        Map<UUID, Integer> totalPlayerCounts = db.query(PlayerCountQueries.newPlayerCounts(0L, now));
        Map<UUID, Integer> newPlayerCounts = db.query(PlayerCountQueries.newPlayerCounts(weekAgo, now));
        Map<UUID, Integer> uniquePlayerCounts = db.query(PlayerCountQueries.uniquePlayerCounts(weekAgo, now));
        ArrayList<Map<String, Object>> servers = new ArrayList<Map<String, Object>>();
        serverInformation.entrySet().stream().sorted(Comparator.comparing(entry -> ((Server)entry.getValue()).getIdentifiableName().toLowerCase())).filter(entry -> ((Server)entry.getValue()).isNotProxy()).forEach(entry -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        return servers;
    }

    public List<Map<String, Object>> pingPerGeolocation(UUID serverUUID) {
        Map<String, Ping> pingByGeolocation = this.dbSystem.getDatabase().query(PingQueries.fetchPingDataOfServerByGeolocation(serverUUID));
        return this.turnToTableEntries(pingByGeolocation);
    }

    public List<Map<String, Object>> pingPerGeolocation() {
        Map<String, Ping> pingByGeolocation = this.dbSystem.getDatabase().query(PingQueries.fetchPingDataOfNetworkByGeolocation());
        return this.turnToTableEntries(pingByGeolocation);
    }

    private List<Map<String, Object>> turnToTableEntries(Map<String, Ping> pingByGeolocation) {
        ArrayList<Map<String, Object>> tableEntries = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Ping> entry : pingByGeolocation.entrySet()) {
            String geolocation = entry.getKey();
            Ping ping = entry.getValue();
            HashMap<String, String> tableEntry = new HashMap<String, String>();
            tableEntry.put("country", geolocation);
            tableEntry.put("avg_ping", (String)this.formatters.decimals().apply(ping.getAverage()) + " ms");
            tableEntry.put("min_ping", ping.getMin() + " ms");
            tableEntry.put("max_ping", ping.getMax() + " ms");
            tableEntries.add(tableEntry);
        }
        return tableEntries;
    }

    private static /* synthetic */ double[][] lambda$null$4(int x$0) {
        return new double[x$0][];
    }
}

