/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.domain.mutators.TPSMutator;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.ServerTabJSONCreator;
import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DisplaySettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.GenericLang;
import com.djrapitops.plan.settings.locale.lang.HtmlLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PerformanceJSONCreator
implements ServerTabJSONCreator<Map<String, Object>> {
    private final PlanConfig config;
    private final Locale locale;
    private final DBSystem dbSystem;
    private final Formatter<Double> decimals;
    private final Formatter<Long> timeAmountFormatter;
    private final Formatter<Double> percentageFormatter;

    @Inject
    public PerformanceJSONCreator(PlanConfig config, Locale locale, DBSystem dbSystem, Formatters formatters) {
        this.config = config;
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.decimals = formatters.decimals();
        this.percentageFormatter = formatters.percentage();
        this.timeAmountFormatter = formatters.timeAmount();
    }

    @Override
    public Map<String, Object> createJSONAsMap(UUID serverUUID) {
        HashMap<String, Object> serverOverview = new HashMap<String, Object>();
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        List<TPS> tpsData = db.query(TPSQueries.fetchTPSDataOfServer(monthAgo, now, serverUUID));
        serverOverview.put("numbers", this.createNumbersMap(tpsData));
        serverOverview.put("insights", this.createInsightsMap(tpsData));
        return serverOverview;
    }

    private Map<String, Object> createNumbersMap(List<TPS> tpsData) {
        long now = System.currentTimeMillis();
        long dayAgo = now - TimeUnit.DAYS.toMillis(1L);
        long weekAgo = now - TimeUnit.DAYS.toMillis(7L);
        HashMap<String, Object> numbers = new HashMap<String, Object>();
        TPSMutator tpsDataMonth = new TPSMutator(tpsData);
        TPSMutator tpsDataWeek = tpsDataMonth.filterDataBetween(weekAgo, now);
        TPSMutator tpsDataDay = tpsDataWeek.filterDataBetween(dayAgo, now);
        Integer tpsThreshold = this.config.get(DisplaySettings.GRAPH_TPS_THRESHOLD_MED);
        numbers.put("low_tps_spikes_30d", tpsDataMonth.lowTpsSpikeCount(tpsThreshold));
        numbers.put("low_tps_spikes_7d", tpsDataWeek.lowTpsSpikeCount(tpsThreshold));
        numbers.put("low_tps_spikes_24h", tpsDataDay.lowTpsSpikeCount(tpsThreshold));
        numbers.put("server_downtime_30d", this.timeAmountFormatter.apply(tpsDataMonth.serverDownTime()));
        numbers.put("server_downtime_7d", this.timeAmountFormatter.apply(tpsDataWeek.serverDownTime()));
        numbers.put("server_downtime_24h", this.timeAmountFormatter.apply(tpsDataDay.serverDownTime()));
        numbers.put("tps_30d", this.format(tpsDataMonth.averageTPS()));
        numbers.put("tps_7d", this.format(tpsDataWeek.averageTPS()));
        numbers.put("tps_24h", this.format(tpsDataDay.averageTPS()));
        numbers.put("cpu_30d", this.formatPerc(tpsDataMonth.averageCPU()));
        numbers.put("cpu_7d", this.formatPerc(tpsDataWeek.averageCPU()));
        numbers.put("cpu_24h", this.formatPerc(tpsDataDay.averageCPU()));
        numbers.put("ram_30d", this.format(tpsDataMonth.averageRAM(), " MB"));
        numbers.put("ram_7d", this.format(tpsDataWeek.averageRAM(), " MB"));
        numbers.put("ram_24h", this.format(tpsDataDay.averageRAM(), " MB"));
        numbers.put("entities_30d", this.format((int)tpsDataMonth.averageEntities()));
        numbers.put("entities_7d", this.format((int)tpsDataWeek.averageEntities()));
        numbers.put("entities_24h", this.format((int)tpsDataDay.averageEntities()));
        numbers.put("chunks_30d", this.format((int)tpsDataMonth.averageChunks()));
        numbers.put("chunks_7d", this.format((int)tpsDataWeek.averageChunks()));
        numbers.put("chunks_24h", this.format((int)tpsDataDay.averageChunks()));
        numbers.put("max_disk_30d", this.format(tpsDataMonth.maxFreeDisk(), " MB"));
        numbers.put("max_disk_7d", this.format(tpsDataWeek.maxFreeDisk(), " MB"));
        numbers.put("max_disk_24h", this.format(tpsDataDay.maxFreeDisk(), " MB"));
        numbers.put("min_disk_30d", this.format(tpsDataMonth.minFreeDisk(), " MB"));
        numbers.put("min_disk_7d", this.format(tpsDataWeek.minFreeDisk(), " MB"));
        numbers.put("min_disk_24h", this.format(tpsDataDay.minFreeDisk(), " MB"));
        return numbers;
    }

    private String format(double value) {
        return value != -1.0 ? (String)this.decimals.apply(value) : this.locale.get(GenericLang.UNAVAILABLE).toString();
    }

    private String format(double value, String suffix) {
        return value != -1.0 ? (String)this.decimals.apply(value) + suffix : this.locale.get(GenericLang.UNAVAILABLE).toString();
    }

    private String formatPerc(double value) {
        return value != -1.0 ? (String)this.percentageFormatter.apply(value / 100.0) : this.locale.get(GenericLang.UNAVAILABLE).toString();
    }

    private Map<String, Object> createInsightsMap(List<TPS> tpsData) {
        TPSMutator tpsMutator = new TPSMutator(tpsData);
        Integer tpsThreshold = this.config.get(DisplaySettings.GRAPH_TPS_THRESHOLD_MED);
        TPSMutator lowTPS = tpsMutator.filterTPSBetween(-1, tpsThreshold);
        HashMap<String, Object> insights = new HashMap<String, Object>();
        double avgPlayersOnline = lowTPS.averagePlayersOnline();
        double averageCPU = lowTPS.averageCPU();
        double averageEntities = lowTPS.averageEntities();
        double averageChunks = lowTPS.averageChunks();
        insights.put("low_tps_players", avgPlayersOnline != -1.0 ? this.decimals.apply(avgPlayersOnline) : this.locale.get(HtmlLang.TEXT_NO_LOW_TPS).toString());
        insights.put("low_tps_cpu", averageCPU != -1.0 ? this.decimals.apply(averageCPU) : "-");
        insights.put("low_tps_entities", averageEntities != -1.0 ? this.decimals.apply(averageEntities) : "-");
        insights.put("low_tps_chunks", averageChunks != -1.0 ? this.decimals.apply(averageChunks) : "-");
        return insights;
    }
}

