/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.ServerTabJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.Trend;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.analysis.ActivityIndexQueries;
import com.djrapitops.plan.storage.database.queries.analysis.PlayerCountQueries;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlayerBaseOverviewJSONCreator
implements ServerTabJSONCreator<Map<String, Object>> {
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final Formatter<Long> timeAmount;
    private final Formatter<Double> percentage;

    @Inject
    public PlayerBaseOverviewJSONCreator(PlanConfig config, DBSystem dbSystem, Formatters formatters) {
        this.config = config;
        this.dbSystem = dbSystem;
        this.timeAmount = formatters.timeAmount();
        this.percentage = formatters.percentage();
    }

    @Override
    public Map<String, Object> createJSONAsMap(UUID serverUUID) {
        HashMap<String, Object> serverOverview = new HashMap<String, Object>();
        serverOverview.put("trends", this.createTrendsMap(serverUUID));
        serverOverview.put("insights", this.createInsightsMap(serverUUID));
        return serverOverview;
    }

    private Map<String, Object> createTrendsMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        long twoMonthsAgo = now - TimeUnit.DAYS.toMillis(60L);
        Long playThreshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        HashMap<String, Object> trends = new HashMap<String, Object>();
        Integer playersBefore = db.query(PlayerCountQueries.newPlayerCount(0L, monthAgo, serverUUID));
        Integer playersAfter = db.query(PlayerCountQueries.newPlayerCount(0L, now, serverUUID));
        trends.put("total_players_then", playersBefore);
        trends.put("total_players_now", playersAfter);
        trends.put("total_players_trend", new Trend(playersBefore.intValue(), playersAfter.intValue(), false));
        Integer regularBefore = db.query(ActivityIndexQueries.fetchRegularPlayerCount(monthAgo, serverUUID, playThreshold));
        Integer regularAfter = db.query(ActivityIndexQueries.fetchRegularPlayerCount(now, serverUUID, playThreshold));
        trends.put("regular_players_then", regularBefore);
        trends.put("regular_players_now", regularAfter);
        trends.put("regular_players_trend", new Trend(regularBefore.intValue(), regularAfter.intValue(), false));
        Long avgPlaytimeBefore = db.query(SessionQueries.averagePlaytimePerPlayer(twoMonthsAgo, monthAgo, serverUUID));
        Long avgPlaytimeAfter = db.query(SessionQueries.averagePlaytimePerPlayer(monthAgo, now, serverUUID));
        trends.put("playtime_avg_then", this.timeAmount.apply(avgPlaytimeBefore));
        trends.put("playtime_avg_now", this.timeAmount.apply(avgPlaytimeAfter));
        trends.put("playtime_avg_trend", new Trend(avgPlaytimeBefore, avgPlaytimeAfter, false, this.timeAmount));
        Long avgAfkBefore = db.query(SessionQueries.averageAfkPerPlayer(twoMonthsAgo, monthAgo, serverUUID));
        Long avgAfkAfter = db.query(SessionQueries.averageAfkPerPlayer(monthAgo, now, serverUUID));
        double afkPercBefore = avgPlaytimeBefore != 0L ? (double)avgAfkBefore.longValue() / (double)avgPlaytimeBefore.longValue() : 0.0;
        double afkPercAfter = avgPlaytimeAfter != 0L ? (double)avgAfkAfter.longValue() / (double)avgPlaytimeAfter.longValue() : 0.0;
        trends.put("afk_then", this.percentage.apply(afkPercBefore));
        trends.put("afk_now", this.percentage.apply(afkPercAfter));
        trends.put("afk_trend", new Trend(afkPercBefore, afkPercAfter, true, this.percentage));
        Long avgRegularPlaytimeBefore = db.query(ActivityIndexQueries.averagePlaytimePerRegularPlayer(twoMonthsAgo, monthAgo, serverUUID, playThreshold));
        Long avgRegularPlaytimeAfter = db.query(ActivityIndexQueries.averagePlaytimePerRegularPlayer(monthAgo, now, serverUUID, playThreshold));
        trends.put("regular_playtime_avg_then", this.timeAmount.apply(avgRegularPlaytimeBefore));
        trends.put("regular_playtime_avg_now", this.timeAmount.apply(avgRegularPlaytimeAfter));
        trends.put("regular_playtime_avg_trend", new Trend(avgRegularPlaytimeBefore, avgRegularPlaytimeAfter, false, this.timeAmount));
        Long avgRegularSessionLengthBefore = db.query(ActivityIndexQueries.averageSessionLengthPerRegularPlayer(twoMonthsAgo, monthAgo, serverUUID, playThreshold));
        Long avgRegularSessionLengthAfter = db.query(ActivityIndexQueries.averageSessionLengthPerRegularPlayer(monthAgo, now, serverUUID, playThreshold));
        trends.put("regular_session_avg_then", this.timeAmount.apply(avgRegularSessionLengthBefore));
        trends.put("regular_session_avg_now", this.timeAmount.apply(avgRegularSessionLengthAfter));
        trends.put("regular_session_avg_trend", new Trend(avgRegularSessionLengthBefore, avgRegularSessionLengthAfter, false, this.timeAmount));
        Long avgRegularAfkBefore = db.query(ActivityIndexQueries.averageAFKPerRegularPlayer(twoMonthsAgo, monthAgo, serverUUID, playThreshold));
        Long avgRegularAfkAfter = db.query(ActivityIndexQueries.averageAFKPerRegularPlayer(monthAgo, now, serverUUID, playThreshold));
        double afkRegularPercBefore = avgRegularPlaytimeBefore != 0L ? (double)avgRegularAfkBefore.longValue() / (double)avgRegularPlaytimeBefore.longValue() : 0.0;
        double afkRegularPercAfter = avgRegularPlaytimeAfter != 0L ? (double)avgRegularAfkAfter.longValue() / (double)avgRegularPlaytimeAfter.longValue() : 0.0;
        trends.put("regular_afk_avg_then", this.percentage.apply(afkRegularPercBefore));
        trends.put("regular_afk_avg_now", this.percentage.apply(afkRegularPercAfter));
        trends.put("regular_afk_avg_trend", new Trend(afkRegularPercBefore, afkRegularPercAfter, true, this.percentage));
        return trends;
    }

    private Map<String, Object> createInsightsMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long halfMonthAgo = now - TimeUnit.DAYS.toMillis(15L);
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        Long playThreshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        HashMap<String, Object> insights = new HashMap<String, Object>();
        int newToRegular = db.query(ActivityIndexQueries.countNewPlayersTurnedRegular(monthAgo, now, serverUUID, playThreshold));
        Integer newToRegularBefore = db.query(ActivityIndexQueries.countNewPlayersTurnedRegular(monthAgo, halfMonthAgo, serverUUID, playThreshold));
        Integer newToRegularAfter = db.query(ActivityIndexQueries.countNewPlayersTurnedRegular(halfMonthAgo, now, serverUUID, playThreshold));
        insights.put("new_to_regular", newToRegular);
        insights.put("new_to_regular_trend", new Trend(newToRegularBefore.intValue(), newToRegularAfter.intValue(), false));
        Integer regularToInactive = db.query(ActivityIndexQueries.countRegularPlayersTurnedInactive(monthAgo, now, serverUUID, playThreshold));
        Integer regularToInactiveBefore = db.query(ActivityIndexQueries.countRegularPlayersTurnedInactive(monthAgo, halfMonthAgo, serverUUID, playThreshold));
        Integer regularToInactiveAfter = db.query(ActivityIndexQueries.countRegularPlayersTurnedInactive(halfMonthAgo, now, serverUUID, playThreshold));
        insights.put("regular_to_inactive", regularToInactive);
        insights.put("regular_to_inactive_trend", new Trend(regularToInactiveBefore.intValue(), regularToInactiveAfter.intValue(), true));
        return insights;
    }
}

