/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.delivery.domain.mutators.PerServerMutator;
import com.djrapitops.plan.delivery.domain.mutators.PingMutator;
import com.djrapitops.plan.delivery.domain.mutators.PlayerKillMutator;
import com.djrapitops.plan.delivery.domain.mutators.PlayerVersusMutator;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.rendering.json.ServerAccordion;
import com.djrapitops.plan.delivery.rendering.json.graphs.Graphs;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.WorldPie;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DisplaySettings;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.GenericLang;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.settings.theme.ThemeVal;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.containers.PlayerContainerQuery;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.utilities.comparators.DateHolderRecentComparator;
import com.djrapitops.plan.utilities.java.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.text.StringEscapeUtils;

@Singleton
public class PlayerJSONCreator {
    private final PlanConfig config;
    private final Locale locale;
    private final Theme theme;
    private final DBSystem dbSystem;
    private final Graphs graphs;
    private final Formatters formatters;
    private final Formatter<Long> timeAmount;
    private final Formatter<Double> decimals;
    private final Formatter<Long> year;

    @Inject
    public PlayerJSONCreator(PlanConfig config, Locale locale, Theme theme, DBSystem dbSystem, Formatters formatters, Graphs graphs) {
        this.config = config;
        this.locale = locale;
        this.theme = theme;
        this.dbSystem = dbSystem;
        this.formatters = formatters;
        this.timeAmount = formatters.timeAmount();
        this.decimals = formatters.decimals();
        this.year = formatters.yearLong();
        this.graphs = graphs;
    }

    public Map<String, Object> createJSONAsMap(UUID playerUUID) {
        Database db = this.dbSystem.getDatabase();
        Map<UUID, String> serverNames = db.query(ServerQueries.fetchServerNames());
        String[] pieColors = this.theme.getPieColors(ThemeVal.GRAPH_WORLD_PIE);
        PlayerContainer player = db.query(new PlayerContainerQuery(playerUUID));
        SessionsMutator sessionsMutator = SessionsMutator.forContainer(player);
        Map<UUID, WorldTimes> worldTimesPerServer = PerServerMutator.forContainer(player).worldTimesPerServer();
        List<Map<String, Object>> serverAccordion = new ServerAccordion(player, serverNames, this.graphs, this.year, this.timeAmount, this.locale.getString(GenericLang.UNKNOWN)).asMaps();
        List<PlayerKill> kills = player.getValue(PlayerKeys.PLAYER_KILLS).orElse(Collections.emptyList());
        List<PlayerKill> deaths = player.getValue(PlayerKeys.PLAYER_DEATHS_KILLS).orElse(Collections.emptyList());
        PingMutator.forContainer(player).addPingToSessions(sessionsMutator.all());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("info", this.createInfoJSONMap(player, serverNames));
        data.put("online_activity", this.createOnlineActivityJSONMap(sessionsMutator));
        data.put("kill_data", this.createPvPPvEMap(player));
        data.put("nicknames", player.getValue(PlayerKeys.NICKNAMES).map(nicks -> Nickname.fromDataNicknames(nicks, serverNames, this.year)).orElse(Collections.emptyList()));
        data.put("connections", player.getValue(PlayerKeys.GEO_INFO).map(geoInfo -> ConnectionInfo.fromGeoInfo(geoInfo, this.year)).orElse(Collections.emptyList()));
        data.put("player_kills", new PlayerKillMutator(kills).filterNonSelfKills().toJSONAsMap(this.formatters));
        data.put("player_deaths", new PlayerKillMutator(deaths).toJSONAsMap(this.formatters));
        data.put("sessions", sessionsMutator.sort(new DateHolderRecentComparator()).toServerNameJSONMaps(this.graphs, this.config.getWorldAliasSettings(), this.formatters));
        data.put("sessions_per_page", this.config.get(DisplaySettings.SESSIONS_PER_PAGE));
        data.put("servers", serverAccordion);
        data.put("punchcard_series", this.graphs.special().punchCard(sessionsMutator).getDots());
        WorldPie worldPie = this.graphs.pie().worldPie(player.getValue(PlayerKeys.WORLD_TIMES).orElse(new WorldTimes()));
        data.put("world_pie_series", worldPie.getSlices());
        data.put("gm_series", worldPie.toHighChartsDrillDownMaps());
        data.put("calendar_series", this.graphs.calendar().playerCalendar(player).getEntries());
        data.put("server_pie_series", this.graphs.pie().serverPreferencePie(serverNames, worldTimesPerServer).getSlices());
        data.put("server_pie_colors", pieColors);
        data.put("first_day", 1);
        return data;
    }

    private Map<String, Object> createOnlineActivityJSONMap(SessionsMutator sessionsMutator) {
        long now = System.currentTimeMillis();
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        long weekAgo = now - TimeUnit.DAYS.toMillis(7L);
        SessionsMutator sessions30d = sessionsMutator.filterSessionsBetween(monthAgo, now);
        SessionsMutator sessions7d = sessions30d.filterSessionsBetween(weekAgo, now);
        HashMap<String, Object> onlineActivity = new HashMap<String, Object>();
        onlineActivity.put("playtime_30d", this.timeAmount.apply(sessions30d.toPlaytime()));
        onlineActivity.put("active_playtime_30d", this.timeAmount.apply(sessions30d.toActivePlaytime()));
        onlineActivity.put("afk_time_30d", this.timeAmount.apply(sessions30d.toAfkTime()));
        onlineActivity.put("average_session_length_30d", this.timeAmount.apply(sessions30d.toAverageSessionLength()));
        onlineActivity.put("median_session_length_30d", this.timeAmount.apply(sessions30d.toMedianSessionLength()));
        onlineActivity.put("session_count_30d", sessions30d.count());
        onlineActivity.put("player_kill_count_30d", sessions30d.toPlayerKillCount());
        onlineActivity.put("mob_kill_count_30d", sessions30d.toMobKillCount());
        onlineActivity.put("death_count_30d", sessions30d.toDeathCount());
        onlineActivity.put("playtime_7d", this.timeAmount.apply(sessions7d.toPlaytime()));
        onlineActivity.put("active_playtime_7d", this.timeAmount.apply(sessions7d.toActivePlaytime()));
        onlineActivity.put("afk_time_7d", this.timeAmount.apply(sessions7d.toAfkTime()));
        onlineActivity.put("average_session_length_7d", this.timeAmount.apply(sessions7d.toAverageSessionLength()));
        onlineActivity.put("median_session_length_7d", this.timeAmount.apply(sessions7d.toMedianSessionLength()));
        onlineActivity.put("session_count_7d", sessions7d.count());
        onlineActivity.put("player_kill_count_7d", sessions7d.toPlayerKillCount());
        onlineActivity.put("mob_kill_count_7d", sessions7d.toMobKillCount());
        onlineActivity.put("death_count_7d", sessions7d.toDeathCount());
        return onlineActivity;
    }

    private Map<String, Object> createInfoJSONMap(PlayerContainer player, Map<UUID, String> serverNames) {
        SessionsMutator sessions = SessionsMutator.forContainer(player);
        ActivityIndex activityIndex = player.getActivityIndex(System.currentTimeMillis(), this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD));
        PerServerMutator perServer = PerServerMutator.forContainer(player);
        PingMutator ping = PingMutator.forContainer(player);
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("online", SessionCache.getCachedSession(player.getUnsafe(PlayerKeys.UUID)).isPresent());
        info.put("operator", player.getValue(PlayerKeys.OPERATOR).orElse(false));
        info.put("banned", player.getValue(PlayerKeys.BANNED).orElse(false));
        info.put("kick_count", player.getValue(PlayerKeys.KICK_COUNT).orElse(0));
        info.put("player_kill_count", player.getValue(PlayerKeys.PLAYER_KILL_COUNT).orElse(0));
        info.put("mob_kill_count", player.getValue(PlayerKeys.MOB_KILL_COUNT).orElse(0));
        info.put("death_count", player.getValue(PlayerKeys.DEATH_COUNT).orElse(0));
        info.put("playtime", this.timeAmount.apply(sessions.toPlaytime()));
        info.put("active_playtime", this.timeAmount.apply(sessions.toActivePlaytime()));
        info.put("afk_time", this.timeAmount.apply(sessions.toAfkTime()));
        info.put("session_count", sessions.count());
        info.put("longest_session_length", this.timeAmount.apply(sessions.toLongestSessionLength()));
        info.put("session_median", this.timeAmount.apply(sessions.toMedianSessionLength()));
        info.put("activity_index", this.decimals.apply(activityIndex.getValue()));
        info.put("activity_index_group", activityIndex.getGroup());
        info.put("favorite_server", perServer.favoriteServer().map(favoriteServer -> serverNames.getOrDefault(favoriteServer, favoriteServer.toString())).orElse(this.locale.getString(GenericLang.UNKNOWN)));
        double averagePing = ping.average();
        int worstPing = ping.max();
        int bestPing = ping.min();
        String unavailable = this.locale.get(GenericLang.UNAVAILABLE).toString();
        info.put("average_ping", averagePing != -1.0 ? (String)this.decimals.apply(averagePing) + " ms" : unavailable);
        info.put("worst_ping", (double)worstPing != -1.0 ? worstPing + " ms" : unavailable);
        info.put("best_ping", (double)bestPing != -1.0 ? bestPing + " ms" : unavailable);
        info.put("registered", player.getValue(PlayerKeys.REGISTERED).map(this.year).orElse("-"));
        info.put("last_seen", player.getValue(PlayerKeys.LAST_SEEN).map(this.year).orElse("-"));
        return info;
    }

    private Map<String, Object> createPvPPvEMap(PlayerContainer playerContainer) {
        long now = System.currentTimeMillis();
        long weekAgo = now - TimeUnit.DAYS.toMillis(7L);
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        PlayerVersusMutator playerVersus = PlayerVersusMutator.forContainer(playerContainer);
        PlayerVersusMutator playerVersus30d = playerVersus.filterBetween(monthAgo, now);
        PlayerVersusMutator playerVersus7d = playerVersus30d.filterBetween(weekAgo, now);
        HashMap<String, Object> killData = new HashMap<String, Object>();
        int pks = playerVersus.toPlayerKillCount();
        int pks7d = playerVersus7d.toPlayerKillCount();
        int pks30d = playerVersus30d.toPlayerKillCount();
        killData.put("player_kills_total", pks);
        killData.put("player_kills_30d", pks30d);
        killData.put("player_kills_7d", pks7d);
        int playerDeaths = playerVersus.toPlayerDeathCount();
        int playerDeaths30d = playerVersus30d.toPlayerDeathCount();
        int playerDeaths7d = playerVersus7d.toPlayerDeathCount();
        killData.put("player_deaths_total", playerDeaths);
        killData.put("player_deaths_30d", playerDeaths30d);
        killData.put("player_deaths_7d", playerDeaths7d);
        double kdr = playerDeaths != 0 ? (double)pks / (double)playerDeaths : (double)pks;
        double kdr30d = playerDeaths30d != 0 ? (double)pks30d / (double)playerDeaths30d : (double)pks30d;
        double krd7d = playerDeaths7d != 0 ? (double)pks7d / (double)playerDeaths7d : (double)pks7d;
        killData.put("player_kdr_total", this.decimals.apply(kdr));
        killData.put("player_kdr_30d", this.decimals.apply(kdr30d));
        killData.put("player_kdr_7d", this.decimals.apply(krd7d));
        int mobKills = playerVersus.toMobKillCount();
        int mobKills30d = playerVersus30d.toMobKillCount();
        int mobKills7d = playerVersus7d.toMobKillCount();
        killData.put("mob_kills_total", mobKills);
        killData.put("mob_kills_30d", mobKills30d);
        killData.put("mob_kills_7d", mobKills7d);
        int deaths = playerVersus.toDeathCount();
        int deaths30d = playerVersus30d.toDeathCount();
        int deaths7d = playerVersus7d.toDeathCount();
        killData.put("deaths_total", deaths);
        killData.put("deaths_30d", deaths30d);
        killData.put("deaths_7d", deaths7d);
        int mobDeaths = deaths - playerDeaths;
        int mobDeaths30d = deaths30d - playerDeaths30d;
        int mobDeaths7d = deaths7d - playerDeaths7d;
        killData.put("mob_deaths_total", mobDeaths);
        killData.put("mob_deaths_30d", mobDeaths30d);
        killData.put("mob_deaths_7d", mobDeaths7d);
        double mobKdr = mobDeaths != 0 ? (double)mobKills / (double)mobDeaths : (double)mobKills;
        double mobKdr30d = mobDeaths30d != 0 ? (double)mobKills30d / (double)mobDeaths30d : (double)mobKills30d;
        double mobKdr7d = mobDeaths7d != 0 ? (double)mobKills7d / (double)mobDeaths7d : (double)mobKills7d;
        killData.put("mob_kdr_total", this.decimals.apply(mobKdr));
        killData.put("mob_kdr_30d", this.decimals.apply(mobKdr30d));
        killData.put("mob_kdr_7d", this.decimals.apply(mobKdr7d));
        List<String> topWeapons = playerVersus.toTopWeapons(3);
        killData.put("weapon_1st", this.getWeapon(topWeapons, 0).orElse("-"));
        killData.put("weapon_2nd", this.getWeapon(topWeapons, 1).orElse("-"));
        killData.put("weapon_3rd", this.getWeapon(topWeapons, 2).orElse("-"));
        return killData;
    }

    private <T> Optional<T> getWeapon(List<T> list, int index) {
        return list.size() <= index ? Optional.empty() : Optional.of(list.get(index));
    }

    public static class ConnectionInfo {
        private final String geolocation;
        private final String date;

        public ConnectionInfo(String geolocation, String date) {
            this.geolocation = geolocation;
            this.date = date;
        }

        public static List<ConnectionInfo> fromGeoInfo(List<GeoInfo> geoInfo, Formatter<Long> dateFormatter) {
            return Lists.map(geoInfo, i -> new ConnectionInfo(i.getGeolocation(), (String)dateFormatter.apply(i.getDate())));
        }
    }

    public static class Nickname {
        private final String nickname;
        private final String server;
        private final String date;

        public Nickname(String nickname, String server, String date) {
            this.nickname = nickname;
            this.server = server;
            this.date = date;
        }

        public static List<Nickname> fromDataNicknames(List<com.djrapitops.plan.delivery.domain.Nickname> nicknames, Map<UUID, String> serverNames, Formatter<Long> dateFormatter) {
            nicknames.sort(new DateHolderRecentComparator());
            ArrayList<Nickname> mapped = new ArrayList<Nickname>();
            for (com.djrapitops.plan.delivery.domain.Nickname nickname : nicknames) {
                mapped.add(new Nickname(Html.swapColorCodesToSpan(StringEscapeUtils.escapeHtml4(nickname.getName())), serverNames.getOrDefault(nickname.getServerUUID(), nickname.getServerUUID().toString()), (String)dateFormatter.apply(nickname.getDate())));
            }
            return mapped;
        }
    }
}

