/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.domain.TablePlayer;
import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.rendering.html.icon.Family;
import com.djrapitops.plan.delivery.rendering.html.icon.Icon;
import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import com.djrapitops.plan.extension.implementation.results.ExtensionDoubleData;
import com.djrapitops.plan.extension.implementation.results.ExtensionNumberData;
import com.djrapitops.plan.extension.implementation.results.ExtensionStringData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.HtmlLang;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import plan.org.apache.commons.lang3.StringUtils;
import plan.org.apache.commons.text.StringEscapeUtils;

public class PlayersTableJSONCreator {
    private final List<TablePlayer> players;
    private final List<ExtensionDescriptive> extensionDescriptives;
    private final Map<UUID, ExtensionTabData> extensionData;
    private final Locale locale;
    private final boolean openPlayerPageInNewTab;
    private final Map<FormatType, Formatter<Long>> numberFormatters;
    private final Formatter<Double> decimalFormatter;

    public PlayersTableJSONCreator(List<TablePlayer> players, Map<UUID, ExtensionTabData> extensionData, boolean openPlayerPageInNewTab, Formatters formatters, Locale locale) {
        this.players = players;
        this.extensionData = extensionData;
        this.locale = locale;
        this.extensionDescriptives = new ArrayList<ExtensionDescriptive>();
        this.addExtensionDescriptives(extensionData);
        this.extensionDescriptives.sort((one, two) -> String.CASE_INSENSITIVE_ORDER.compare(one.getName(), two.getName()));
        this.openPlayerPageInNewTab = openPlayerPageInNewTab;
        this.numberFormatters = new EnumMap<FormatType, Formatter<Long>>(FormatType.class);
        this.numberFormatters.put(FormatType.DATE_SECOND, formatters.secondLong());
        this.numberFormatters.put(FormatType.DATE_YEAR, formatters.yearLong());
        this.numberFormatters.put(FormatType.TIME_MILLISECONDS, formatters.timeAmount());
        this.numberFormatters.put(FormatType.NONE, Object::toString);
        this.decimalFormatter = formatters.decimals();
    }

    private void addExtensionDescriptives(Map<UUID, ExtensionTabData> extensionData) {
        HashSet<String> foundDescriptives = new HashSet<String>();
        for (ExtensionTabData tabData : extensionData.values()) {
            for (ExtensionDescriptive descriptive : tabData.getDescriptives()) {
                if (foundDescriptives.contains(descriptive.getName())) continue;
                this.extensionDescriptives.add(descriptive);
                foundDescriptives.add(descriptive.getName());
            }
        }
    }

    public String toJSONString() {
        String data = this.createData();
        String columnHeaders = this.createColumnHeaders();
        return "{\"columns\":" + columnHeaders + ",\"data\":" + data + '}';
    }

    private String createData() {
        StringBuilder dataJSON = new StringBuilder("[");
        int currentPlayerNumber = 0;
        for (TablePlayer player : this.players) {
            UUID playerUUID = player.getPlayerUUID();
            if (playerUUID == null) continue;
            if (currentPlayerNumber > 0) {
                dataJSON.append(',');
            }
            dataJSON.append('{');
            this.appendPlayerData(dataJSON, player);
            this.appendExtensionData(dataJSON, this.extensionData.getOrDefault(playerUUID, new ExtensionTabData.Builder(null).build()));
            dataJSON.append('}');
            ++currentPlayerNumber;
        }
        return dataJSON.append(']').toString();
    }

    private void appendPlayerData(StringBuilder dataJSON, TablePlayer player) {
        String name = player.getName().orElse(player.getPlayerUUID().toString());
        String url = "../player/" + Html.encodeToURL(name);
        int loginTimes = player.getSessionCount().orElse(0);
        long playtime = player.getPlaytime().orElse(-1L);
        long registered = player.getRegistered().orElse(-1L);
        long lastSeen = player.getLastSeen().orElse(-1L);
        ActivityIndex activityIndex = player.getCurrentActivityIndex().orElseGet(() -> new ActivityIndex(0.0, 0L));
        boolean isBanned = player.isBanned();
        String activityString = activityIndex.getFormattedValue(this.decimalFormatter) + (isBanned ? " (<b>" + this.locale.get(HtmlLang.LABEL_BANNED) + "</b>)" : " (" + activityIndex.getGroup() + ")");
        String geolocation = player.getGeolocation().orElse("-");
        Html link = this.openPlayerPageInNewTab ? Html.LINK_EXTERNAL : Html.LINK;
        dataJSON.append(this.makeDataEntry(link.create(new Serializable[]{url, StringUtils.replace(StringEscapeUtils.escapeHtml4(name), "\\", "\\\\")}), "name")).append(',').append(this.makeDataEntry(activityIndex.getValue(), activityString, "index")).append(',').append(this.makeDataEntry(playtime, (String)this.numberFormatters.get((Object)FormatType.TIME_MILLISECONDS).apply(playtime), "playtime")).append(',').append(this.makeDataEntry(loginTimes, "sessions")).append(',').append(this.makeDataEntry(registered, (String)this.numberFormatters.get((Object)FormatType.DATE_YEAR).apply(registered), "registered")).append(',').append(this.makeDataEntry(lastSeen, (String)this.numberFormatters.get((Object)FormatType.DATE_YEAR).apply(lastSeen), "seen")).append(',').append(this.makeDataEntry(geolocation, "geolocation"));
    }

    private String makeDataEntry(Object data, String dataName) {
        return "\"" + dataName + "\":\"" + data.toString().replace('\"', '\'') + "\"";
    }

    private String makeDataEntry(Object data, String formatted, String dataName) {
        return "\"" + dataName + "\":{\"v\":\"" + data.toString().replace('\"', '\'') + "\", \"d\":\"" + formatted.replace('\"', '\'') + "\"}";
    }

    private void appendExtensionData(StringBuilder dataJSON, ExtensionTabData tabData) {
        for (ExtensionDescriptive descriptive : this.extensionDescriptives) {
            dataJSON.append(',');
            String key = descriptive.getName();
            Optional<ExtensionDoubleData> doubleValue = tabData.getDouble(key);
            if (doubleValue.isPresent()) {
                dataJSON.append(this.makeDataEntry(doubleValue.get().getRawValue(), doubleValue.get().getFormattedValue(this.decimalFormatter), key));
                continue;
            }
            Optional<ExtensionNumberData> numberValue = tabData.getNumber(key);
            if (numberValue.isPresent()) {
                ExtensionNumberData numberData = numberValue.get();
                FormatType formatType = numberData.getFormatType();
                dataJSON.append(this.makeDataEntry(numberData.getRawValue(), numberData.getFormattedValue(this.numberFormatters.get((Object)formatType)), key));
                continue;
            }
            String stringValue = tabData.getString(key).map(ExtensionStringData::getFormattedValue).orElse("-");
            dataJSON.append(this.makeDataEntry(stringValue, stringValue, key));
        }
    }

    private String createColumnHeaders() {
        StringBuilder columnHeaders = new StringBuilder("[");
        columnHeaders.append(this.makeColumnHeader(Icon.called("user") + " " + this.locale.get(HtmlLang.LABEL_NAME), "name")).append(',').append(this.makeFColumnHeader(Icon.called("check") + " " + this.locale.get(HtmlLang.LABEL_ACTIVITY_INDEX), "index")).append(',').append(this.makeFColumnHeader(Icon.called("clock").of(Family.REGULAR) + " " + this.locale.get(HtmlLang.LABEL_PLAYTIME), "playtime")).append(',').append(this.makeColumnHeader(Icon.called("calendar-plus").of(Family.REGULAR) + " " + this.locale.get(HtmlLang.SIDE_SESSIONS), "sessions")).append(',').append(this.makeFColumnHeader(Icon.called("user-plus") + " " + this.locale.get(HtmlLang.LABEL_REGISTERED), "registered")).append(',').append(this.makeFColumnHeader(Icon.called("calendar-check").of(Family.REGULAR) + " " + this.locale.get(HtmlLang.LABEL_LAST_SEEN), "seen")).append(',').append(this.makeColumnHeader(Icon.called("globe") + " " + this.locale.get(HtmlLang.TITLE_COUNTRY), "geolocation"));
        this.appendExtensionHeaders(columnHeaders);
        return columnHeaders.append(']').toString();
    }

    private String makeColumnHeader(String title, String dataProperty) {
        return "{\"title\": \"" + title.replace('\"', '\'') + "\",\"data\":\"" + dataProperty + "\"}";
    }

    private String makeFColumnHeader(String title, String dataProperty) {
        return "{\"title\": \"" + title.replace('\"', '\'') + "\",\"data\":{\"_\":\"" + dataProperty + ".v\",\"display\":\"" + dataProperty + ".d\"}}";
    }

    private void appendExtensionHeaders(StringBuilder columnHeaders) {
        for (ExtensionDescriptive provider : this.extensionDescriptives) {
            columnHeaders.append(',');
            String headerText = Icon.fromExtensionIcon(provider.getIcon().setColor(Color.NONE)).toHtml().replace('\"', '\'') + ' ' + provider.getText();
            columnHeaders.append(this.makeFColumnHeader(headerText, provider.getName()));
        }
    }
}

