/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.ServerTabJSONCreator;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.KillQueries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PvPPvEJSONCreator
implements ServerTabJSONCreator<Map<String, Object>> {
    private final DBSystem dbSystem;
    private final Formatter<Double> decimals;

    @Inject
    public PvPPvEJSONCreator(DBSystem dbSystem, Formatters formatters) {
        this.dbSystem = dbSystem;
        this.decimals = formatters.decimals();
    }

    @Override
    public Map<String, Object> createJSONAsMap(UUID serverUUID) {
        HashMap<String, Object> serverOverview = new HashMap<String, Object>();
        serverOverview.put("numbers", this.createNumbersMap(serverUUID));
        serverOverview.put("insights", this.createInsightsMap(serverUUID));
        return serverOverview;
    }

    private Map<String, Object> createNumbersMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long weekAgo = now - TimeUnit.DAYS.toMillis(7L);
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        HashMap<String, Object> numbers = new HashMap<String, Object>();
        Long pks = db.query(KillQueries.playerKillCount(0L, now, serverUUID));
        Long pks7d = db.query(KillQueries.playerKillCount(weekAgo, now, serverUUID));
        Long pks30d = db.query(KillQueries.playerKillCount(monthAgo, now, serverUUID));
        numbers.put("player_kills_total", pks);
        numbers.put("player_kills_30d", pks30d);
        numbers.put("player_kills_7d", pks7d);
        numbers.put("player_kdr_avg", this.decimals.apply(db.query(KillQueries.averageKDR(0L, now, serverUUID))));
        numbers.put("player_kdr_avg_30d", this.decimals.apply(db.query(KillQueries.averageKDR(monthAgo, now, serverUUID))));
        numbers.put("player_kdr_avg_7d", this.decimals.apply(db.query(KillQueries.averageKDR(weekAgo, now, serverUUID))));
        Long mobKills = db.query(KillQueries.mobKillCount(0L, now, serverUUID));
        Long mobKills30d = db.query(KillQueries.mobKillCount(monthAgo, now, serverUUID));
        Long mobKills7d = db.query(KillQueries.mobKillCount(weekAgo, now, serverUUID));
        numbers.put("mob_kills_total", mobKills);
        numbers.put("mob_kills_30d", mobKills30d);
        numbers.put("mob_kills_7d", mobKills7d);
        Long deaths = db.query(KillQueries.deathCount(0L, now, serverUUID));
        Long deaths30d = db.query(KillQueries.deathCount(monthAgo, now, serverUUID));
        Long deaths7d = db.query(KillQueries.deathCount(weekAgo, now, serverUUID));
        numbers.put("deaths_total", deaths);
        numbers.put("deaths_30d", deaths30d);
        numbers.put("deaths_7d", deaths7d);
        long mobDeaths = deaths - pks;
        long mobDeaths30d = deaths30d - pks30d;
        long mobDeaths7d = deaths7d - pks7d;
        numbers.put("mob_deaths_total", mobDeaths);
        numbers.put("mob_deaths_30d", mobDeaths30d);
        numbers.put("mob_deaths_7d", mobDeaths7d);
        double mobKdr = mobDeaths != 0L ? (double)mobKills.longValue() / (double)mobDeaths : (double)mobKills.longValue();
        double mobKdr30d = mobDeaths30d != 0L ? (double)mobKills30d.longValue() / (double)mobDeaths30d : (double)mobKills30d.longValue();
        double mobKdr7d = mobDeaths7d != 0L ? (double)mobKills7d.longValue() / (double)mobDeaths7d : (double)mobKills7d.longValue();
        numbers.put("mob_kdr_total", this.decimals.apply(mobKdr));
        numbers.put("mob_kdr_30d", this.decimals.apply(mobKdr30d));
        numbers.put("mob_kdr_7d", this.decimals.apply(mobKdr7d));
        return numbers;
    }

    private Map<String, Object> createInsightsMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        HashMap<String, Object> insights = new HashMap<String, Object>();
        List<String> top3Weapons = db.query(KillQueries.topWeaponsOfServer(monthAgo, now, serverUUID, 3));
        insights.put("weapon_1st", this.getWeapon(top3Weapons, 0).orElse("-"));
        insights.put("weapon_2nd", this.getWeapon(top3Weapons, 1).orElse("-"));
        insights.put("weapon_3rd", this.getWeapon(top3Weapons, 2).orElse("-"));
        return insights;
    }

    private <T> Optional<T> getWeapon(List<T> list, int index) {
        return list.size() <= index ? Optional.empty() : Optional.of(list.get(index));
    }
}

