/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.container.PerServerContainer;
import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PerServerKeys;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.rendering.json.graphs.Graphs;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.WorldPie;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ServerAccordion {
    private final Map<UUID, String> serverNames;
    private final PerServerContainer perServer;
    private final String unknown;
    private final Graphs graphs;
    private final Formatter<Long> year;
    private final Formatter<Long> timeAmount;

    public ServerAccordion(PlayerContainer container, Map<UUID, String> serverNames, Graphs graphs, Formatter<Long> year, Formatter<Long> timeAmount, String unknown) {
        this.graphs = graphs;
        this.year = year;
        this.timeAmount = timeAmount;
        this.serverNames = serverNames;
        this.perServer = container.getValue(PlayerKeys.PER_SERVER).orElse(new PerServerContainer());
        this.unknown = unknown;
    }

    public List<Map<String, Object>> asMaps() {
        ArrayList<Map<String, Object>> servers = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : this.perServer.entrySet()) {
            UUID serverUUID = (UUID)entry.getKey();
            DataContainer perServer = (DataContainer)entry.getValue();
            HashMap<String, Object> server = new HashMap<String, Object>();
            String serverName = this.serverNames.getOrDefault(serverUUID, this.unknown);
            WorldTimes worldTimes = perServer.getValue(PerServerKeys.WORLD_TIMES).orElse(new WorldTimes());
            SessionsMutator sessionsMutator = SessionsMutator.forContainer(perServer);
            server.put("server_name", serverName);
            server.put("banned", perServer.getValue(PerServerKeys.BANNED).orElse(false));
            server.put("operator", perServer.getValue(PerServerKeys.OPERATOR).orElse(false));
            server.put("registered", this.year.apply(perServer.getValue(PerServerKeys.REGISTERED).orElse(0L)));
            server.put("last_seen", this.year.apply(sessionsMutator.toLastSeen()));
            server.put("session_count", sessionsMutator.count());
            server.put("playtime", this.timeAmount.apply(sessionsMutator.toPlaytime()));
            server.put("afk_time", this.timeAmount.apply(sessionsMutator.toAfkTime()));
            server.put("session_median", this.timeAmount.apply(sessionsMutator.toMedianSessionLength()));
            server.put("longest_session_length", this.timeAmount.apply(sessionsMutator.toLongestSessionLength()));
            server.put("mob_kills", sessionsMutator.toMobKillCount());
            server.put("player_kills", sessionsMutator.toPlayerKillCount());
            server.put("deaths", sessionsMutator.toDeathCount());
            WorldPie worldPie = this.graphs.pie().worldPie(worldTimes);
            server.put("world_pie_series", worldPie.getSlices());
            server.put("gm_series", worldPie.toHighChartsDrillDownMaps());
            servers.add(server);
        }
        return servers;
    }
}

