/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.domain.DateHolder;
import com.djrapitops.plan.delivery.domain.DateObj;
import com.djrapitops.plan.delivery.domain.mutators.TPSMutator;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.ServerTabJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.Trend;
import com.djrapitops.plan.gathering.ServerSensor;
import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DisplaySettings;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.GenericLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.ServerAggregateQueries;
import com.djrapitops.plan.storage.database.queries.analysis.ActivityIndexQueries;
import com.djrapitops.plan.storage.database.queries.analysis.PlayerCountQueries;
import com.djrapitops.plan.storage.database.queries.objects.KillQueries;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ServerOverviewJSONCreator
implements ServerTabJSONCreator<Map<String, Object>> {
    private final Formatter<Long> day;
    private final PlanConfig config;
    private final Locale locale;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final ServerSensor<?> serverSensor;
    private final Formatter<Long> timeAmount;
    private final Formatter<Double> decimals;
    private final Formatter<Double> percentage;
    private final Formatter<DateHolder> year;

    @Inject
    public ServerOverviewJSONCreator(PlanConfig config, Locale locale, DBSystem dbSystem, ServerInfo serverInfo, ServerSensor<?> serverSensor, Formatters formatters) {
        this.config = config;
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.serverSensor = serverSensor;
        this.year = formatters.year();
        this.day = formatters.dayLong();
        this.timeAmount = formatters.timeAmount();
        this.decimals = formatters.decimals();
        this.percentage = formatters.percentage();
    }

    @Override
    public Map<String, Object> createJSONAsMap(UUID serverUUID) {
        HashMap<String, Object> serverOverview = new HashMap<String, Object>();
        serverOverview.put("last_7_days", this.createLast7DaysMap(serverUUID));
        serverOverview.put("numbers", this.createNumbersMap(serverUUID));
        serverOverview.put("weeks", this.createWeeksMap(serverUUID));
        return serverOverview;
    }

    private Map<String, Object> createLast7DaysMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long weekAgo = now - TimeUnit.DAYS.toMillis(7L);
        HashMap<String, Object> sevenDays = new HashMap<String, Object>();
        sevenDays.put("unique_players", db.query(PlayerCountQueries.uniquePlayerCount(weekAgo, now, serverUUID)));
        sevenDays.put("unique_players_day", db.query(PlayerCountQueries.averageUniquePlayerCount(weekAgo, now, this.config.getTimeZone().getOffset(now), serverUUID)));
        int new7d = db.query(PlayerCountQueries.newPlayerCount(weekAgo, now, serverUUID));
        int retained7d = db.query(PlayerCountQueries.retainedPlayerCount(weekAgo, now, serverUUID));
        double retentionPerc7d = new7d != 0 ? (double)retained7d / (double)new7d : -1.0;
        sevenDays.put("new_players", new7d);
        sevenDays.put("new_players_retention", retained7d);
        sevenDays.put("new_players_retention_perc", this.percentage.apply(retentionPerc7d));
        TPSMutator tpsMutator = new TPSMutator(db.query(TPSQueries.fetchTPSDataOfServer(weekAgo, now, serverUUID)));
        double averageTPS = tpsMutator.averageTPS();
        sevenDays.put("average_tps", averageTPS != -1.0 ? this.decimals.apply(averageTPS) : this.locale.get(GenericLang.UNAVAILABLE).toString());
        sevenDays.put("low_tps_spikes", tpsMutator.lowTpsSpikeCount(this.config.get(DisplaySettings.GRAPH_TPS_THRESHOLD_MED)));
        sevenDays.put("downtime", this.timeAmount.apply(tpsMutator.serverDownTime()));
        return sevenDays;
    }

    private Map<String, Object> createNumbersMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long twoDaysAgo = now - TimeUnit.DAYS.toMillis(2L);
        Long playtimeThreshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        HashMap<String, Object> numbers = new HashMap<String, Object>();
        Integer userCount = db.query(ServerAggregateQueries.serverUserCount(serverUUID));
        numbers.put("total_players", userCount);
        numbers.put("regular_players", db.query(ActivityIndexQueries.fetchRegularPlayerCount(now, serverUUID, playtimeThreshold)));
        numbers.put("online_players", this.getOnlinePlayers(serverUUID, db));
        Optional<DateObj<Integer>> lastPeak = db.query(TPSQueries.fetchPeakPlayerCount(serverUUID, twoDaysAgo));
        Optional<DateObj<Integer>> allTimePeak = db.query(TPSQueries.fetchAllTimePeakPlayerCount(serverUUID));
        numbers.put("last_peak_date", lastPeak.map(this.year).orElse("-"));
        numbers.put("last_peak_players", lastPeak.map(dateObj -> ((Integer)dateObj.getValue()).toString()).orElse("-"));
        numbers.put("best_peak_date", allTimePeak.map(this.year).orElse("-"));
        numbers.put("best_peak_players", allTimePeak.map(dateObj -> ((Integer)dateObj.getValue()).toString()).orElse("-"));
        Long totalPlaytime = db.query(SessionQueries.playtime(0L, now, serverUUID));
        numbers.put("playtime", this.timeAmount.apply(totalPlaytime));
        numbers.put("player_playtime", userCount != 0 ? this.timeAmount.apply(totalPlaytime / (long)userCount.intValue()) : "-");
        numbers.put("sessions", db.query(SessionQueries.sessionCount(0L, now, serverUUID)));
        numbers.put("player_kills", db.query(KillQueries.playerKillCount(0L, now, serverUUID)));
        numbers.put("mob_kills", db.query(KillQueries.mobKillCount(0L, now, serverUUID)));
        numbers.put("deaths", db.query(KillQueries.deathCount(0L, now, serverUUID)));
        return numbers;
    }

    private Object getOnlinePlayers(UUID serverUUID, Database db) {
        return serverUUID.equals(this.serverInfo.getServerUUID()) ? Integer.valueOf(this.serverSensor.getOnlinePlayerCount()) : db.query(TPSQueries.fetchLatestTPSEntryForServer(serverUUID)).map(TPS::getPlayers).map(Object::toString).orElse(this.locale.get(GenericLang.UNKNOWN).toString());
    }

    private Map<String, Object> createWeeksMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long oneWeekAgo = now - TimeUnit.DAYS.toMillis(7L);
        long twoWeeksAgo = now - TimeUnit.DAYS.toMillis(14L);
        Long playtimeThreshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        HashMap<String, Object> weeks = new HashMap<String, Object>();
        weeks.put("start", this.day.apply(twoWeeksAgo));
        weeks.put("midpoint", this.day.apply(oneWeekAgo));
        weeks.put("end", this.day.apply(now));
        Integer uniqueBefore = db.query(PlayerCountQueries.uniquePlayerCount(twoWeeksAgo, oneWeekAgo, serverUUID));
        Integer uniqueAfter = db.query(PlayerCountQueries.uniquePlayerCount(oneWeekAgo, now, serverUUID));
        Trend uniqueTrend = new Trend(uniqueBefore.intValue(), uniqueAfter.intValue(), false);
        weeks.put("unique_before", uniqueBefore);
        weeks.put("unique_after", uniqueAfter);
        weeks.put("unique_trend", uniqueTrend);
        Integer newBefore = db.query(PlayerCountQueries.newPlayerCount(twoWeeksAgo, oneWeekAgo, serverUUID));
        Integer newAfter = db.query(PlayerCountQueries.newPlayerCount(oneWeekAgo, now, serverUUID));
        Trend newTrend = new Trend(newBefore.intValue(), newAfter.intValue(), false);
        weeks.put("new_before", newBefore);
        weeks.put("new_after", newAfter);
        weeks.put("new_trend", newTrend);
        int regularBefore = db.query(ActivityIndexQueries.fetchRegularPlayerCount(oneWeekAgo, serverUUID, playtimeThreshold));
        int regularAfter = db.query(ActivityIndexQueries.fetchRegularPlayerCount(now, serverUUID, playtimeThreshold));
        weeks.put("regular_before", regularBefore);
        weeks.put("regular_after", regularAfter);
        weeks.put("regular_trend", new Trend(regularBefore, regularAfter, false));
        Long playtimeBefore = db.query(SessionQueries.playtime(twoWeeksAgo, oneWeekAgo, serverUUID));
        Long playtimeAfter = db.query(SessionQueries.playtime(oneWeekAgo, now, serverUUID));
        long avgPlaytimeBefore = uniqueBefore != 0 ? playtimeBefore / (long)uniqueBefore.intValue() : 0L;
        long avgPlaytimeAfter = uniqueAfter != 0 ? playtimeAfter / (long)uniqueAfter.intValue() : 0L;
        Trend avgPlaytimeTrend = new Trend(avgPlaytimeBefore, avgPlaytimeAfter, false, this.timeAmount);
        weeks.put("average_playtime_before", this.timeAmount.apply(avgPlaytimeBefore));
        weeks.put("average_playtime_after", this.timeAmount.apply(avgPlaytimeAfter));
        weeks.put("average_playtime_trend", avgPlaytimeTrend);
        Long sessionsBefore = db.query(SessionQueries.sessionCount(twoWeeksAgo, oneWeekAgo, serverUUID));
        Long sessionsAfter = db.query(SessionQueries.sessionCount(oneWeekAgo, now, serverUUID));
        Trend sessionsTrend = new Trend(sessionsBefore, sessionsAfter, false);
        weeks.put("sessions_before", sessionsBefore);
        weeks.put("sessions_after", sessionsAfter);
        weeks.put("sessions_trend", sessionsTrend);
        Long pksBefore = db.query(KillQueries.playerKillCount(twoWeeksAgo, oneWeekAgo, serverUUID));
        Long pksAfter = db.query(KillQueries.playerKillCount(oneWeekAgo, now, serverUUID));
        Trend pksTrend = new Trend(pksBefore, pksAfter, false);
        weeks.put("player_kills_before", pksBefore);
        weeks.put("player_kills_after", pksAfter);
        weeks.put("player_kills_trend", pksTrend);
        Long mkBefore = db.query(KillQueries.mobKillCount(twoWeeksAgo, oneWeekAgo, serverUUID));
        Long mkAfter = db.query(KillQueries.mobKillCount(oneWeekAgo, now, serverUUID));
        Trend mkTrend = new Trend(mkBefore, mkAfter, false);
        weeks.put("mob_kills_before", mkBefore);
        weeks.put("mob_kills_after", mkAfter);
        weeks.put("mob_kills_trend", mkTrend);
        Long deathsBefore = db.query(KillQueries.deathCount(twoWeeksAgo, oneWeekAgo, serverUUID));
        Long deathsAfter = db.query(KillQueries.deathCount(oneWeekAgo, now, serverUUID));
        Trend deathTrend = new Trend(deathsBefore, deathsAfter, true);
        weeks.put("deaths_before", deathsBefore);
        weeks.put("deaths_after", deathsAfter);
        weeks.put("deaths_trend", deathTrend);
        return weeks;
    }
}

