/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.domain.mutators.TPSMutator;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.ServerTabJSONCreator;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import com.djrapitops.plan.storage.database.queries.objects.WorldTimesQueries;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.text.WordUtils;

@Singleton
public class SessionsOverviewJSONCreator
implements ServerTabJSONCreator<Map<String, Object>> {
    private final DBSystem dbSystem;
    private final Formatter<Long> timeAmount;
    private final Formatter<Double> percentage;

    @Inject
    public SessionsOverviewJSONCreator(DBSystem dbSystem, Formatters formatters) {
        this.dbSystem = dbSystem;
        this.timeAmount = formatters.timeAmount();
        this.percentage = formatters.percentage();
    }

    @Override
    public Map<String, Object> createJSONAsMap(UUID serverUUID) {
        return Collections.singletonMap("insights", this.createInsightsMap(serverUUID));
    }

    private Map<String, Object> createInsightsMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        List<TPS> tpsData = db.query(TPSQueries.fetchTPSDataOfServer(monthAgo, now, serverUUID));
        TPSMutator tpsMutator = new TPSMutator(tpsData);
        HashMap<String, Object> insights = new HashMap<String, Object>();
        long uptime = TimeUnit.DAYS.toMillis(30L) - tpsMutator.serverDownTime();
        long occupied = tpsMutator.serverOccupiedTime();
        insights.put("server_occupied", this.timeAmount.apply(occupied));
        insights.put("server_occupied_perc", uptime != 0L ? this.percentage.apply(1.0 * (double)occupied / (double)uptime) : "-");
        Long playtime = db.query(SessionQueries.playtime(monthAgo, now, serverUUID));
        Long afkTime = db.query(SessionQueries.afkTime(monthAgo, now, serverUUID));
        insights.put("total_playtime", this.timeAmount.apply(playtime));
        insights.put("afk_time", this.timeAmount.apply(afkTime));
        insights.put("afk_time_perc", playtime != 0L ? this.percentage.apply(1.0 * (double)afkTime.longValue() / (double)playtime.longValue()) : "-");
        GMTimes gmTimes = db.query(WorldTimesQueries.fetchGMTimes(monthAgo, now, serverUUID));
        Optional<String> mostUsedGameMode = gmTimes.getMostUsedGameMode();
        Long longestGMTime = mostUsedGameMode.map(gmTimes::getTime).orElse(-1L);
        insights.put("most_active_gamemode", mostUsedGameMode.map(WordUtils::capitalizeFully).orElse("Not Known"));
        insights.put("most_active_gamemode_perc", playtime != 0L ? this.percentage.apply(1.0 * (double)longestGMTime.longValue() / (double)playtime.longValue()) : "-");
        return insights;
    }
}

