/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json;

import com.djrapitops.plan.delivery.formatting.Formatter;

public class Trend {
    public static final boolean REVERSED = true;
    private final String text;
    private final String direction;
    private final boolean reversed;

    public Trend(long before, long after, boolean reversed) {
        long difference = Math.abs(before - after);
        this.text = Long.toString(difference);
        this.direction = this.getDirection(before, after);
        this.reversed = reversed;
    }

    public Trend(long before, long after, boolean reversed, Formatter<Long> formatter) {
        long difference = Math.abs(before - after);
        this.text = (String)formatter.apply(difference);
        this.direction = this.getDirection(before, after);
        this.reversed = reversed;
    }

    public Trend(double before, double after, boolean reversed, Formatter<Double> formatter) {
        double difference = Math.abs(before - after);
        this.text = (String)formatter.apply(difference);
        this.direction = this.getDirection(before, after);
        this.reversed = reversed;
    }

    private String getDirection(double before, double after) {
        if (before < after) {
            return "+";
        }
        if (before > after) {
            return "-";
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public String getDirection() {
        return this.direction;
    }

    public boolean isReversed() {
        return this.reversed;
    }
}

