/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs;

import com.djrapitops.plan.delivery.domain.DateMap;
import com.djrapitops.plan.delivery.domain.mutators.MutatorFunctions;
import com.djrapitops.plan.delivery.domain.mutators.PingMutator;
import com.djrapitops.plan.delivery.domain.mutators.TPSMutator;
import com.djrapitops.plan.delivery.rendering.json.graphs.Graphs;
import com.djrapitops.plan.delivery.rendering.json.graphs.bar.Bar;
import com.djrapitops.plan.delivery.rendering.json.graphs.bar.BarGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.LineGraphFactory;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.PingGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.Point;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.Pie;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.WorldPie;
import com.djrapitops.plan.delivery.rendering.json.graphs.special.PunchCard;
import com.djrapitops.plan.delivery.rendering.json.graphs.special.WorldMap;
import com.djrapitops.plan.delivery.rendering.json.graphs.stack.StackGraph;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DisplaySettings;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.settings.theme.ThemeVal;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.analysis.ActivityIndexQueries;
import com.djrapitops.plan.storage.database.queries.analysis.NetworkActivityIndexQueries;
import com.djrapitops.plan.storage.database.queries.analysis.PlayerCountQueries;
import com.djrapitops.plan.storage.database.queries.objects.GeoInfoQueries;
import com.djrapitops.plan.storage.database.queries.objects.PingQueries;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import com.djrapitops.plan.storage.database.queries.objects.WorldTimesQueries;
import com.djrapitops.plan.utilities.java.Lists;
import com.djrapitops.plan.utilities.java.Maps;
import com.djrapitops.plugin.api.TimeAmount;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class GraphJSONCreator {
    private final PlanConfig config;
    private final Theme theme;
    private final DBSystem dbSystem;
    private final Graphs graphs;

    @Inject
    public GraphJSONCreator(PlanConfig config, Theme theme, DBSystem dbSystem, Graphs graphs) {
        this.config = config;
        this.theme = theme;
        this.dbSystem = dbSystem;
        this.graphs = graphs;
    }

    public String performanceGraphJSON(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        LineGraphFactory lineGraphs = this.graphs.line();
        long now = System.currentTimeMillis();
        long halfYearAgo = now - TimeUnit.DAYS.toMillis(180L);
        TPSMutator tpsMutator = new TPSMutator(db.query(TPSQueries.fetchTPSDataOfServer(serverUUID))).filterDataBetween(halfYearAgo, now);
        return "{\"playersOnline\":" + lineGraphs.playersOnlineGraph(tpsMutator).toHighChartsSeries() + ",\"tps\":" + lineGraphs.tpsGraph(tpsMutator).toHighChartsSeries() + ",\"cpu\":" + lineGraphs.cpuGraph(tpsMutator).toHighChartsSeries() + ",\"ram\":" + lineGraphs.ramGraph(tpsMutator).toHighChartsSeries() + ",\"entities\":" + lineGraphs.entityGraph(tpsMutator).toHighChartsSeries() + ",\"chunks\":" + lineGraphs.chunkGraph(tpsMutator).toHighChartsSeries() + ",\"disk\":" + lineGraphs.diskGraph(tpsMutator).toHighChartsSeries() + ",\"colors\":{\"playersOnline\":\"" + this.theme.getValue(ThemeVal.GRAPH_PLAYERS_ONLINE) + "\",\"cpu\":\"" + this.theme.getValue(ThemeVal.GRAPH_CPU) + "\",\"ram\":\"" + this.theme.getValue(ThemeVal.GRAPH_RAM) + "\",\"entities\":\"" + this.theme.getValue(ThemeVal.GRAPH_ENTITIES) + "\",\"chunks\":\"" + this.theme.getValue(ThemeVal.GRAPH_CHUNKS) + "\",\"low\":\"" + this.theme.getValue(ThemeVal.GRAPH_TPS_LOW) + "\",\"med\":\"" + this.theme.getValue(ThemeVal.GRAPH_TPS_MED) + "\",\"high\":\"" + this.theme.getValue(ThemeVal.GRAPH_TPS_HIGH) + "\"},\"zones\":{\"tpsThresholdMed\":" + this.config.get(DisplaySettings.GRAPH_TPS_THRESHOLD_MED) + ',' + "\"tpsThresholdHigh\":" + this.config.get(DisplaySettings.GRAPH_TPS_THRESHOLD_HIGH) + ',' + "\"diskThresholdMed\":" + this.config.get(DisplaySettings.GRAPH_DISK_THRESHOLD_MED) + ',' + "\"diskThresholdHigh\":" + this.config.get(DisplaySettings.GRAPH_DISK_THRESHOLD_HIGH) + "}}";
    }

    public String playersOnlineGraph(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long halfYearAgo = now - TimeUnit.DAYS.toMillis(180L);
        List<Point> points = Lists.map((Collection)db.query(TPSQueries.fetchPlayersOnlineOfServer(halfYearAgo, now, serverUUID)), point -> new Point((double)point.getDate(), ((Integer)point.getValue()).intValue()));
        return "{\"playersOnline\":" + this.graphs.line().lineGraph(points).toHighChartsSeries() + ",\"color\":\"" + this.theme.getValue(ThemeVal.GRAPH_PLAYERS_ONLINE) + "\"}";
    }

    public String uniqueAndNewGraphJSON(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        LineGraphFactory lineGraphs = this.graphs.line();
        long now = System.currentTimeMillis();
        long halfYearAgo = now - TimeUnit.DAYS.toMillis(180L);
        int timeZoneOffset = this.config.getTimeZone().getOffset(now);
        NavigableMap<Long, Integer> uniquePerDay = db.query(PlayerCountQueries.uniquePlayerCounts(halfYearAgo, now, timeZoneOffset, serverUUID));
        NavigableMap<Long, Integer> newPerDay = db.query(PlayerCountQueries.newPlayerCounts(halfYearAgo, now, timeZoneOffset, serverUUID));
        return this.createUniqueAndNewJSON(lineGraphs, uniquePerDay, newPerDay, TimeUnit.DAYS.toMillis(1L));
    }

    public String hourlyUniqueAndNewGraphJSON(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        LineGraphFactory lineGraphs = this.graphs.line();
        long now = System.currentTimeMillis();
        long weekAgo = now - TimeUnit.DAYS.toMillis(7L);
        int timeZoneOffset = this.config.getTimeZone().getOffset(now);
        NavigableMap<Long, Integer> uniquePerDay = db.query(PlayerCountQueries.hourlyUniquePlayerCounts(weekAgo, now, timeZoneOffset, serverUUID));
        NavigableMap<Long, Integer> newPerDay = db.query(PlayerCountQueries.newPlayerCounts(weekAgo, now, timeZoneOffset, serverUUID));
        return this.createUniqueAndNewJSON(lineGraphs, uniquePerDay, newPerDay, TimeUnit.HOURS.toMillis(1L));
    }

    public String createUniqueAndNewJSON(LineGraphFactory lineGraphs, NavigableMap<Long, Integer> uniquePerDay, NavigableMap<Long, Integer> newPerDay, long gapFillPeriod) {
        return "{\"uniquePlayers\":" + lineGraphs.lineGraph(MutatorFunctions.toPoints(MutatorFunctions.addMissing(uniquePerDay, gapFillPeriod, (Integer)0))).toHighChartsSeries() + ",\"newPlayers\":" + lineGraphs.lineGraph(MutatorFunctions.toPoints(MutatorFunctions.addMissing(newPerDay, gapFillPeriod, (Integer)0))).toHighChartsSeries() + ",\"colors\":{\"playersOnline\":\"" + this.theme.getValue(ThemeVal.GRAPH_PLAYERS_ONLINE) + "\",\"newPlayers\":\"" + this.theme.getValue(ThemeVal.LIGHT_GREEN) + "\"}}";
    }

    public String uniqueAndNewGraphJSON() {
        Database db = this.dbSystem.getDatabase();
        LineGraphFactory lineGraphs = this.graphs.line();
        long now = System.currentTimeMillis();
        long halfYearAgo = now - TimeUnit.DAYS.toMillis(180L);
        int timeZoneOffset = this.config.getTimeZone().getOffset(now);
        NavigableMap<Long, Integer> uniquePerDay = db.query(PlayerCountQueries.uniquePlayerCounts(halfYearAgo, now, timeZoneOffset));
        NavigableMap<Long, Integer> newPerDay = db.query(PlayerCountQueries.newPlayerCounts(halfYearAgo, now, timeZoneOffset));
        return this.createUniqueAndNewJSON(lineGraphs, uniquePerDay, newPerDay, TimeUnit.DAYS.toMillis(1L));
    }

    public String hourlyUniqueAndNewGraphJSON() {
        Database db = this.dbSystem.getDatabase();
        LineGraphFactory lineGraphs = this.graphs.line();
        long now = System.currentTimeMillis();
        long weekAgo = now - TimeUnit.DAYS.toMillis(7L);
        int timeZoneOffset = this.config.getTimeZone().getOffset(now);
        NavigableMap<Long, Integer> uniquePerDay = db.query(PlayerCountQueries.hourlyUniquePlayerCounts(weekAgo, now, timeZoneOffset));
        NavigableMap<Long, Integer> newPerDay = db.query(PlayerCountQueries.hourlyNewPlayerCounts(weekAgo, now, timeZoneOffset));
        return this.createUniqueAndNewJSON(lineGraphs, uniquePerDay, newPerDay, TimeUnit.HOURS.toMillis(1L));
    }

    public String serverCalendarJSON(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long twoYearsAgo = now - TimeUnit.DAYS.toMillis(730L);
        int timeZoneOffset = this.config.getTimeZone().getOffset(now);
        NavigableMap<Long, Integer> uniquePerDay = db.query(PlayerCountQueries.uniquePlayerCounts(twoYearsAgo, now, timeZoneOffset, serverUUID));
        NavigableMap<Long, Integer> newPerDay = db.query(PlayerCountQueries.newPlayerCounts(twoYearsAgo, now, timeZoneOffset, serverUUID));
        NavigableMap<Long, Long> playtimePerDay = db.query(SessionQueries.playtimePerDay(twoYearsAgo, now, timeZoneOffset, serverUUID));
        NavigableMap<Long, Integer> sessionsPerDay = db.query(SessionQueries.sessionCountPerDay(twoYearsAgo, now, timeZoneOffset, serverUUID));
        return "{\"data\":" + this.graphs.calendar().serverCalendar(uniquePerDay, newPerDay, playtimePerDay, sessionsPerDay).toCalendarSeries() + ",\"firstDay\":" + 1 + '}';
    }

    public Map<String, Object> serverWorldPieJSONAsMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        WorldTimes worldTimes = db.query(WorldTimesQueries.fetchServerTotalWorldTimes(serverUUID));
        WorldPie worldPie = this.graphs.pie().worldPie(worldTimes);
        return Maps.builder(String.class, Object.class).put("world_series", worldPie.getSlices()).put("gm_series", worldPie.toHighChartsDrillDownMaps()).build();
    }

    public Map<String, Object> activityGraphsJSONAsMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long date = System.currentTimeMillis();
        Long threshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        DateMap<Map<String, Integer>> activityData = new DateMap<Map<String, Integer>>();
        for (long time = date; time >= date - TimeAmount.MONTH.toMillis(2L); time -= TimeAmount.WEEK.toMillis(1L)) {
            activityData.put(time, db.query(ActivityIndexQueries.fetchActivityIndexGroupingsOn(time, serverUUID, threshold)));
        }
        return this.createActivityGraphJSON(activityData);
    }

    public Map<String, Object> createActivityGraphJSON(DateMap<Map<String, Integer>> activityData) {
        Map.Entry lastActivityEntry = activityData.lastEntry();
        Pie activityPie = this.graphs.pie().activityPie(lastActivityEntry != null ? (Map)lastActivityEntry.getValue() : Collections.emptyMap());
        StackGraph activityStackGraph = this.graphs.stack().activityStackGraph(activityData);
        return Maps.builder(String.class, Object.class).put("activity_series", activityStackGraph.getDataSets()).put("activity_labels", activityStackGraph.getLabels()).put("activity_pie_series", activityPie.getSlices()).build();
    }

    public Map<String, Object> activityGraphsJSONAsMap() {
        Database db = this.dbSystem.getDatabase();
        long date = System.currentTimeMillis();
        Long threshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        DateMap<Map<String, Integer>> activityData = new DateMap<Map<String, Integer>>();
        for (long time = date; time >= date - TimeAmount.MONTH.toMillis(2L); time -= TimeAmount.WEEK.toMillis(1L)) {
            activityData.put(time, db.query(NetworkActivityIndexQueries.fetchActivityIndexGroupingsOn(time, threshold)));
        }
        return this.createActivityGraphJSON(activityData);
    }

    public Map<String, Object> geolocationGraphsJSONAsMap(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        Map<String, Integer> geolocationCounts = db.query(GeoInfoQueries.serverGeolocationCounts(serverUUID));
        return this.createGeolocationJSON(geolocationCounts);
    }

    public Map<String, Object> createGeolocationJSON(Map<String, Integer> geolocationCounts) {
        BarGraph geolocationBarGraph = this.graphs.bar().geolocationBarGraph(geolocationCounts);
        WorldMap worldMap = this.graphs.special().worldMap(geolocationCounts);
        return Maps.builder(String.class, Object.class).put("geolocation_series", worldMap.getEntries()).put("geolocation_bar_series", geolocationBarGraph.getBars()).put("colors", (List<Bar>)((Object)Maps.builder(String.class, String.class).put("low", this.theme.getValue(ThemeVal.WORLD_MAP_LOW)).put("high", this.theme.getValue(ThemeVal.WORLD_MAP_HIGH)).put("bars", this.theme.getValue(ThemeVal.GREEN)).build())).build();
    }

    public Map<String, Object> geolocationGraphsJSONAsMap() {
        Database db = this.dbSystem.getDatabase();
        Map<String, Integer> geolocationCounts = db.query(GeoInfoQueries.networkGeolocationCounts());
        return this.createGeolocationJSON(geolocationCounts);
    }

    public String pingGraphsJSON(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        List<Ping> pings = db.query(PingQueries.fetchPingDataOfServer(now - TimeUnit.DAYS.toMillis(180L), now, serverUUID));
        PingGraph pingGraph = this.graphs.line().pingGraph(new PingMutator(pings).mutateToByMinutePings().all());
        return "{\"min_ping_series\":" + pingGraph.getMinGraph().toHighChartsSeries() + ",\"avg_ping_series\":" + pingGraph.getAvgGraph().toHighChartsSeries() + ",\"max_ping_series\":" + pingGraph.getMaxGraph().toHighChartsSeries() + ",\"colors\":{\"min\":\"" + this.theme.getValue(ThemeVal.GRAPH_MIN_PING) + "\",\"avg\":\"" + this.theme.getValue(ThemeVal.GRAPH_AVG_PING) + "\",\"max\":\"" + this.theme.getValue(ThemeVal.GRAPH_MAX_PING) + "\"}}";
    }

    public Map<String, Object> punchCardJSONAsMap(UUID serverUUID) {
        long now = System.currentTimeMillis();
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        List<Session> sessions = this.dbSystem.getDatabase().query(SessionQueries.fetchServerSessionsWithoutKillOrWorldData(monthAgo, now, serverUUID));
        return Maps.builder(String.class, Object.class).put("punchCard", this.graphs.special().punchCard(sessions).getDots()).put("color", (List<PunchCard.Dot>)((Object)this.theme.getValue(ThemeVal.GRAPH_PUNCHCARD))).build();
    }

    public Map<String, Object> serverPreferencePieJSONAsMap() {
        long now = System.currentTimeMillis();
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        String[] pieColors = this.theme.getPieColors(ThemeVal.GRAPH_WORLD_PIE);
        Map<String, Long> playtimePerServer = this.dbSystem.getDatabase().query(SessionQueries.playtimePerServer(now, monthAgo));
        return Maps.builder(String.class, Object.class).put("server_pie_colors", pieColors).put("server_pie_series_30d", this.graphs.pie().serverPreferencePie(playtimePerServer).getSlices()).build();
    }
}

