/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.bar;

import com.djrapitops.plan.delivery.domain.mutators.PlayersMutator;
import com.djrapitops.plan.delivery.rendering.json.graphs.bar.Bar;
import com.djrapitops.plan.delivery.rendering.json.graphs.bar.BarGraph;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GeolocationBarGraph
extends BarGraph {
    GeolocationBarGraph(PlayersMutator mutator) {
        this(mutator.getGeolocations());
    }

    private GeolocationBarGraph(List<String> geolocations) {
        super(GeolocationBarGraph.turnToBars(GeolocationBarGraph.toGeolocationCounts(geolocations)));
    }

    GeolocationBarGraph(Map<String, Integer> geolocationCounts) {
        super(GeolocationBarGraph.turnToBars(geolocationCounts));
    }

    private static List<Bar> turnToBars(Map<String, Integer> geolocationCounts) {
        return geolocationCounts.entrySet().stream().map(entry -> new Bar((String)entry.getKey(), ((Integer)entry.getValue()).intValue())).sorted().limit(20L).collect(Collectors.toList());
    }

    private static Map<String, Integer> toGeolocationCounts(List<String> geolocations) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String geolocation : geolocations) {
            counts.put(geolocation, counts.getOrDefault(geolocation, 0) + 1);
        }
        return counts;
    }
}

