/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.calendar;

import java.io.Serializable;
import java.util.Optional;

public class CalendarEntry {
    private final String title;
    private final Serializable start;
    private Serializable end;
    private String color;

    private CalendarEntry(String title, Serializable start) {
        this.title = title;
        this.start = start;
    }

    public static CalendarEntry of(String title, Serializable start) {
        return new CalendarEntry(title, start);
    }

    public CalendarEntry withEnd(Serializable end) {
        this.end = end;
        return this;
    }

    public CalendarEntry withColor(String color) {
        this.color = color;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Serializable getStart() {
        return this.start;
    }

    public Optional<Serializable> getEnd() {
        return Optional.ofNullable(this.end);
    }

    public Optional<String> getColor() {
        return Optional.ofNullable(this.color);
    }

    public String toString() {
        return "{title:'" + this.title + '\'' + ", start:'" + this.start + '\'' + (this.end != null ? ", end='" + this.end + '\'' : "") + (this.color != null ? ", color='" + this.color + '\'' : "") + '}';
    }
}

