/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.calendar;

import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.graphs.calendar.PlayerCalendar;
import com.djrapitops.plan.delivery.rendering.json.graphs.calendar.ServerCalendar;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.theme.Theme;
import java.util.NavigableMap;
import java.util.SortedMap;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class CalendarFactory {
    private final Theme theme;
    private final PlanConfig config;
    private final Locale locale;
    private final Formatters formatters;

    @Inject
    public CalendarFactory(PlanConfig config, Locale locale, Formatters formatters, Theme theme) {
        this.config = config;
        this.locale = locale;
        this.formatters = formatters;
        this.theme = theme;
    }

    public PlayerCalendar playerCalendar(PlayerContainer player) {
        return new PlayerCalendar(player, this.formatters.timeAmount(), this.formatters.yearLong(), this.formatters.iso8601NoClockLong(), this.theme, this.locale, this.config.getTimeZone());
    }

    public ServerCalendar serverCalendar(SortedMap<Long, Integer> uniquePerDay, SortedMap<Long, Integer> newPerDay, SortedMap<Long, Long> playtimePerDay, NavigableMap<Long, Integer> sessionsPerDay) {
        return new ServerCalendar(uniquePerDay, newPerDay, playtimePerDay, sessionsPerDay, this.formatters.iso8601NoClockTZIndependentLong(), this.formatters.timeAmount(), this.theme, this.locale);
    }
}

