/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.calendar;

import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.rendering.json.graphs.calendar.CalendarEntry;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.HtmlLang;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.settings.theme.ThemeVal;
import com.djrapitops.plan.utilities.java.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class PlayerCalendar {
    private final Formatter<Long> timeAmount;
    private final Formatter<Long> year;
    private final Formatter<Long> iso8601Formatter;
    private final Theme theme;
    private final Locale locale;
    private final TimeZone timeZone;
    private final List<Session> allSessions;
    private final long registered;

    PlayerCalendar(PlayerContainer container, Formatter<Long> timeAmount, Formatter<Long> year, Formatter<Long> iso8601Formatter, Theme theme, Locale locale, TimeZone timeZone) {
        this.allSessions = container.getValue(PlayerKeys.SESSIONS).orElse(new ArrayList());
        this.registered = container.getValue(PlayerKeys.REGISTERED).orElse(0L);
        this.timeAmount = timeAmount;
        this.year = year;
        this.iso8601Formatter = iso8601Formatter;
        this.theme = theme;
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public List<CalendarEntry> getEntries() {
        ArrayList<CalendarEntry> entries = new ArrayList<CalendarEntry>();
        entries.add(CalendarEntry.of(this.locale.getString(HtmlLang.LABEL_REGISTERED) + ": " + (String)this.year.apply(this.registered), Long.valueOf(this.registered)).withColor(this.theme.getValue(ThemeVal.LIGHT_GREEN)));
        Map<String, List<Session>> sessionsByDay = this.getSessionsByDay();
        for (Map.Entry<String, List<Session>> entry : sessionsByDay.entrySet()) {
            String day = entry.getKey();
            List<Session> sessions = entry.getValue();
            int sessionCount = sessions.size();
            long playtime = sessions.stream().mapToLong(Session::getLength).sum();
            entries.add(CalendarEntry.of(this.locale.getString(HtmlLang.LABEL_PLAYTIME) + ": " + (String)this.timeAmount.apply(playtime), (Serializable)((Object)day)).withColor(this.theme.getValue(ThemeVal.GREEN)));
            entries.add(CalendarEntry.of(this.locale.getString(HtmlLang.SIDE_SESSIONS) + ": " + sessionCount, (Serializable)((Object)day)));
        }
        long fiveMinutes = TimeUnit.MINUTES.toMillis(5L);
        for (Session session : this.allSessions) {
            String length = (String)this.timeAmount.apply(session.getLength());
            Long start = session.getUnsafe(SessionKeys.START);
            Long end = session.getValue(SessionKeys.END).orElse(System.currentTimeMillis());
            entries.add(CalendarEntry.of(this.locale.getString(HtmlLang.SESSION) + ": " + length, Long.valueOf(start + (long)this.timeZone.getOffset(start))).withEnd(Long.valueOf(end + (long)this.timeZone.getOffset(end))));
            for (PlayerKill kill : session.getPlayerKills()) {
                long time = kill.getDate();
                String victim = kill.getVictimName().orElse(kill.getVictim().toString());
                entries.add(CalendarEntry.of(this.locale.getString(HtmlLang.KILLED) + ": " + victim, Long.valueOf(time)).withEnd(Long.valueOf(time + fiveMinutes)).withColor(this.theme.getValue(ThemeVal.RED)));
            }
        }
        return entries;
    }

    private Map<String, List<Session>> getSessionsByDay() {
        HashMap<String, List<Session>> sessionsByDay = new HashMap<String, List<Session>>();
        for (Session session : this.allSessions) {
            String day = (String)this.iso8601Formatter.apply(session.getDate());
            List sessionsOfDay = sessionsByDay.computeIfAbsent(day, Lists::create);
            sessionsOfDay.add(session);
        }
        return sessionsByDay;
    }
}

