/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.calendar;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.HtmlLang;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.settings.theme.ThemeVal;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;

public class ServerCalendar {
    private final SortedMap<Long, Integer> uniquePerDay;
    private final SortedMap<Long, Integer> newPerDay;
    private final SortedMap<Long, Integer> sessionsPerDay;
    private final SortedMap<Long, Long> playtimePerDay;
    private final Formatter<Long> iso8601TZIndependent;
    private final Formatter<Long> timeAmount;
    private final Theme theme;
    private final Locale locale;

    ServerCalendar(SortedMap<Long, Integer> uniquePerDay, SortedMap<Long, Integer> newPerDay, SortedMap<Long, Long> playtimePerDay, NavigableMap<Long, Integer> sessionsPerDay, Formatter<Long> iso8601TZIndependent, Formatter<Long> timeAmount, Theme theme, Locale locale) {
        this.uniquePerDay = uniquePerDay;
        this.newPerDay = newPerDay;
        this.iso8601TZIndependent = iso8601TZIndependent;
        this.timeAmount = timeAmount;
        this.sessionsPerDay = sessionsPerDay;
        this.playtimePerDay = playtimePerDay;
        this.theme = theme;
        this.locale = locale;
    }

    public String toCalendarSeries() {
        StringBuilder series = new StringBuilder("[");
        series.append("{\"title\": \"badcode\",\"start\":0}");
        this.appendTimeZoneOffsetData(series);
        return series.append("]").toString();
    }

    private void appendTimeZoneOffsetData(StringBuilder series) {
        this.appendUniquePlayers(series);
        this.appendNewPlayers(series);
        this.appendSessionCounts(series);
        this.appendPlaytime(series);
    }

    private void appendNewPlayers(StringBuilder series) {
        for (Map.Entry<Long, Integer> entry : this.newPerDay.entrySet()) {
            int newPlayers = entry.getValue();
            if (newPlayers <= 0) continue;
            Long key = entry.getKey();
            String day = (String)this.iso8601TZIndependent.apply(key);
            series.append(",{\"title\": \"").append(this.locale.get(HtmlLang.NEW_CALENDAR)).append(" ").append(newPlayers).append("\",\"start\":\"").append(day).append("\",\"color\": \"").append(this.theme.getValue(ThemeVal.LIGHT_GREEN)).append('\"').append("}");
        }
    }

    private void appendUniquePlayers(StringBuilder series) {
        for (Map.Entry<Long, Integer> entry : this.uniquePerDay.entrySet()) {
            long uniquePlayers = entry.getValue().intValue();
            if (uniquePlayers <= 0L) continue;
            Long key = entry.getKey();
            String day = (String)this.iso8601TZIndependent.apply(key);
            series.append(",{\"title\": \"").append(this.locale.get(HtmlLang.UNIQUE_CALENDAR)).append(" ").append(uniquePlayers).append("\",\"start\":\"").append(day).append("\"}");
        }
    }

    private void appendPlaytime(StringBuilder series) {
        for (Map.Entry<Long, Long> entry : this.playtimePerDay.entrySet()) {
            long playtime = entry.getValue();
            if (playtime <= 0L) continue;
            Long key = entry.getKey();
            String day = (String)this.iso8601TZIndependent.apply(key);
            series.append(",{\"title\": \"").append(this.locale.get(HtmlLang.LABEL_PLAYTIME)).append(": ").append((String)this.timeAmount.apply(playtime)).append("\",\"start\":\"").append(day).append("\",\"color\": \"").append(this.theme.getValue(ThemeVal.GREEN)).append('\"').append("}");
        }
    }

    private void appendSessionCounts(StringBuilder series) {
        for (Map.Entry<Long, Integer> entry : this.sessionsPerDay.entrySet()) {
            int sessionCount = entry.getValue();
            if (sessionCount <= 0) continue;
            Long key = entry.getKey();
            String day = (String)this.iso8601TZIndependent.apply(key);
            series.append(",{\"title\": \"").append(this.locale.get(HtmlLang.SIDE_SESSIONS)).append(": ").append(sessionCount).append("\",\"start\":\"").append(day).append("\",\"color\": \"").append(this.theme.getValue(ThemeVal.TEAL)).append('\"').append("}");
        }
    }
}

