/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.line;

import com.djrapitops.plan.delivery.domain.mutators.MutatorFunctions;
import com.djrapitops.plan.delivery.rendering.json.graphs.HighChart;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.Point;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LineGraph
implements HighChart {
    private final boolean displayGaps;
    private final List<Point> points;

    public LineGraph(List<Point> points, boolean displayGaps) {
        this.points = points;
        this.displayGaps = displayGaps;
    }

    @Override
    public String toHighChartsSeries() {
        StringBuilder arrayBuilder = new StringBuilder("[");
        int size = this.points.size();
        Long lastX = null;
        for (int i = 0; i < size; ++i) {
            Point point = this.points.get(i);
            Double y = point.getY();
            long date = (long)point.getX();
            if (this.displayGaps && lastX != null && date - lastX > TimeUnit.MINUTES.toMillis(3L)) {
                this.addMissingPoints(arrayBuilder, lastX, date);
            }
            lastX = date;
            arrayBuilder.append("[").append(date).append(",").append(y).append("]");
            if (i >= size - 1) continue;
            arrayBuilder.append(",");
        }
        arrayBuilder.append("]");
        return arrayBuilder.toString();
    }

    public List<Point> getPoints() {
        if (this.displayGaps) {
            return MutatorFunctions.addMissing(this.points, TimeUnit.MINUTES.toMillis(1L), null);
        }
        return this.points;
    }

    private void addMissingPoints(StringBuilder arrayBuilder, Long lastX, long date) {
        for (long iterate = lastX + TimeUnit.MINUTES.toMillis(1L); iterate < date; iterate += TimeUnit.MINUTES.toMillis(30L)) {
            arrayBuilder.append("[").append(iterate).append(",null],");
        }
    }
}

