/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.line;

import com.djrapitops.plan.delivery.domain.mutators.TPSMutator;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.CPUGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.ChunkGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.DiskGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.EntityGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.LineGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.PingGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.PlayersOnlineGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.Point;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.RamGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.TPSGraph;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DisplaySettings;
import com.djrapitops.plan.utilities.comparators.PointComparator;
import java.util.List;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class LineGraphFactory {
    private final PlanConfig config;

    @Inject
    public LineGraphFactory(PlanConfig config) {
        this.config = config;
    }

    public LineGraph lineGraph(List<Point> points) {
        points.sort(new PointComparator());
        return new LineGraph(points, this.shouldDisplayGapsInData());
    }

    public LineGraph chunkGraph(TPSMutator mutator) {
        return new ChunkGraph(mutator, this.shouldDisplayGapsInData());
    }

    public LineGraph cpuGraph(TPSMutator mutator) {
        return new CPUGraph(mutator, this.shouldDisplayGapsInData());
    }

    public LineGraph entityGraph(TPSMutator mutator) {
        return new EntityGraph(mutator, this.shouldDisplayGapsInData());
    }

    public LineGraph playersOnlineGraph(TPSMutator mutator) {
        return new PlayersOnlineGraph(mutator, this.shouldDisplayGapsInData());
    }

    public PingGraph pingGraph(List<Ping> pingList) {
        return new PingGraph(pingList, this.shouldDisplayGapsInData());
    }

    public LineGraph ramGraph(TPSMutator mutator) {
        return new RamGraph(mutator, this.shouldDisplayGapsInData());
    }

    public LineGraph tpsGraph(TPSMutator mutator) {
        return new TPSGraph(mutator, this.shouldDisplayGapsInData());
    }

    public LineGraph diskGraph(TPSMutator mutator) {
        return new DiskGraph(mutator, this.shouldDisplayGapsInData());
    }

    private boolean shouldDisplayGapsInData() {
        return this.config.isTrue(DisplaySettings.GAPS_IN_GRAPH_DATA);
    }
}

